<?php $__env->startSection('title', 'Thêm lịch nhân viên'); ?>

<?php $__env->startSection('content'); ?>
<div class="d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h3 mb-0 text-gray-800">Thêm lịch nhân viên</h1>
    <a href="<?php echo e(route('admin.working-schedules.index')); ?>" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> Quay lại
    </a>
</div>

<div class="card shadow mb-4">
    <div class="card-header py-3">
        <h6 class="m-0 font-weight-bold text-primary">Thông tin lịch</h6>
    </div>
    <div class="card-body">
        <?php if(session('warning')): ?>
            <div class="alert alert-warning alert-dismissible fade show" role="alert">
                <i class="fas fa-exclamation-triangle"></i> <?php echo e(session('warning')); ?>

                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        <?php endif; ?>

        <?php if(session('error')): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <i class="fas fa-times-circle"></i> <?php echo e(session('error')); ?>

                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        <?php endif; ?>

        <?php if(session('conflicts')): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <strong><i class="fas fa-times-circle"></i> Các lịch bị trùng:</strong>
                <ul class="mb-0 mt-2">
                    <?php $__currentLoopData = session('conflicts'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $conflict): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($conflict); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        <?php endif; ?>

        <form action="<?php echo e(route('admin.working-schedules.store')); ?>" method="POST" class="needs-validation" novalidate onsubmit="return validateForm();">
            <?php echo csrf_field(); ?>

            <div class="form-group">
                <label>Chế độ xếp lịch <span class="text-danger">*</span></label>
                <div class="form-check">
                    <input class="form-check-input" type="radio" name="schedule_type" id="schedule_type_day" value="day" <?php echo e(old('schedule_type', 'day') == 'day' ? 'checked' : ''); ?> onchange="toggleScheduleType()">
                    <label class="form-check-label" for="schedule_type_day">
                        Theo ngày
                    </label>
                </div>
                <div class="form-check">
                    <input class="form-check-input" type="radio" name="schedule_type" id="schedule_type_week" value="week" <?php echo e(old('schedule_type') == 'week' ? 'checked' : ''); ?> onchange="toggleScheduleType()">
                    <label class="form-check-label" for="schedule_type_week">
                        Theo tuần
                    </label>
                </div>
            </div>

            <div class="form-group" id="day_input_group">
                <label for="work_date">Ngày làm việc <span class="text-danger">*</span></label>
                <input type="date" name="work_date" id="work_date" value="<?php echo e(old('work_date')); ?>" 
                       class="form-control <?php $__errorArgs = ['work_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                       min="<?php echo e(\Carbon\Carbon::now('Asia/Ho_Chi_Minh')->format('Y-m-d')); ?>" 
                       required>
                <?php $__errorArgs = ['work_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                <?php else: ?>
                    <div class="invalid-feedback">Vui lòng chọn ngày làm việc</div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div class="form-group" id="week_input_group" style="display: none;">
                <label for="week_start_date">Tuần bắt đầu từ <span class="text-danger">*</span></label>
                <input type="date" name="week_start_date" id="week_start_date" value="<?php echo e(old('week_start_date')); ?>" 
                       class="form-control <?php $__errorArgs = ['week_start_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                       min="<?php echo e(\Carbon\Carbon::now('Asia/Ho_Chi_Minh')->format('Y-m-d')); ?>" 
                       required>
                <?php $__errorArgs = ['week_start_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                <?php else: ?>
                    <div class="invalid-feedback">Vui lòng chọn ngày bắt đầu tuần</div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                <small class="form-text text-muted">Chọn thứ 2 của tuần (hoặc ngày bất kỳ, hệ thống sẽ tự động tính tuần từ thứ 2 đến chủ nhật)</small>
            </div>

            <div class="form-group">
                <label for="shift_ids">Ca làm việc <span class="text-danger">*</span></label>
                <div class="d-flex align-items-center gap-2 mb-2">
                    <select name="shift_ids[]" id="shift_ids" class="form-control select2-multiple <?php $__errorArgs = ['shift_ids'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> <?php $__errorArgs = ['shift_ids.*'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" multiple required>
                        <?php $__currentLoopData = $shifts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $shift): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($shift->id); ?>" <?php echo e((old('shift_ids') && in_array($shift->id, old('shift_ids'))) ? 'selected' : ''); ?>>
                                <?php echo e($shift->name); ?> (<?php echo e($shift->display_time); ?>)
                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <?php
                        // Tìm ca "Ca cả ngày" (7h-22h)
                        $fullDayShift = $shifts->firstWhere('name', 'Ca cả ngày') ?? $shifts->first(function($shift) {
                            return $shift->formatted_start_time === '07:00' && $shift->formatted_end_time === '22:00';
                        });
                    ?>
                    <?php if($fullDayShift): ?>
                        <button type="button" class="btn btn-info btn-sm" id="btn_full_day_shift" title="Chọn ca cả ngày (7h-22h)">
                            <i class="fas fa-calendar-day"></i> Ca cả ngày
                        </button>
                    <?php endif; ?>
                </div>
                <?php $__errorArgs = ['shift_ids'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="invalid-feedback d-block"><?php echo e($message); ?></div>
                <?php elseif($errors->has('shift_ids.*')): ?>
                    <div class="invalid-feedback d-block"><?php echo e($errors->first('shift_ids.*')); ?></div>
                <?php else: ?>
                    <div class="invalid-feedback">Vui lòng chọn ít nhất một ca làm việc</div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                <small class="form-text text-muted">Mỗi ca sẽ có đủ 4 vị trí: Thợ tạo kiểu, Thợ cắt tóc nam, Nhân viên gội đầu, Lễ tân</small>
            </div>

            <hr class="my-4">
            <h5 class="mb-3">Chọn nhân viên cho từng vị trí <span class="text-danger">*</span></h5>
            <p class="text-muted mb-3"><small>Bạn có thể chọn nhiều nhân viên cho mỗi vị trí</small></p>

            <div class="form-row">
                <div class="form-group col-md-6">
                    <label for="stylist_ids">Thợ tạo kiểu <span class="text-danger">*</span></label>
                    <select name="stylist_ids[]" id="stylist_ids" class="form-control select2-multiple <?php $__errorArgs = ['stylist_ids'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> <?php $__errorArgs = ['stylist_ids.*'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" multiple required>
                        <?php $__currentLoopData = $stylists; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stylist): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($stylist->id); ?>" <?php echo e((old('stylist_ids') && in_array($stylist->id, old('stylist_ids'))) ? 'selected' : ''); ?>>
                                <?php echo e($stylist->user->name ?? 'N/A'); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <?php $__errorArgs = ['stylist_ids'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback d-block"><?php echo e($message); ?></div>
                    <?php elseif($errors->has('stylist_ids.*')): ?>
                        <div class="invalid-feedback d-block"><?php echo e($errors->first('stylist_ids.*')); ?></div>
                    <?php else: ?>
                        <div class="invalid-feedback">Vui lòng chọn ít nhất một Thợ tạo kiểu</div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div class="form-group col-md-6">
                    <label for="barber_ids">Thợ cắt tóc nam <span class="text-danger">*</span></label>
                    <select name="barber_ids[]" id="barber_ids" class="form-control select2-multiple <?php $__errorArgs = ['barber_ids'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> <?php $__errorArgs = ['barber_ids.*'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" multiple required>
                        <?php $__currentLoopData = $barbers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $barber): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($barber->id); ?>" <?php echo e((old('barber_ids') && in_array($barber->id, old('barber_ids'))) ? 'selected' : ''); ?>>
                                <?php echo e($barber->user->name ?? 'N/A'); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <?php $__errorArgs = ['barber_ids'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback d-block"><?php echo e($message); ?></div>
                    <?php elseif($errors->has('barber_ids.*')): ?>
                        <div class="invalid-feedback d-block"><?php echo e($errors->first('barber_ids.*')); ?></div>
                    <?php else: ?>
                        <div class="invalid-feedback">Vui lòng chọn ít nhất một Thợ cắt tóc nam</div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>

            <div class="form-row">
                <div class="form-group col-md-6">
                    <label for="shampooer_ids">Nhân viên gội đầu <span class="text-danger">*</span></label>
                    <select name="shampooer_ids[]" id="shampooer_ids" class="form-control select2-multiple <?php $__errorArgs = ['shampooer_ids'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> <?php $__errorArgs = ['shampooer_ids.*'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" multiple required>
                        <?php $__currentLoopData = $shampooers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $shampooer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($shampooer->id); ?>" <?php echo e((old('shampooer_ids') && in_array($shampooer->id, old('shampooer_ids'))) ? 'selected' : ''); ?>>
                                <?php echo e($shampooer->user->name ?? 'N/A'); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <?php $__errorArgs = ['shampooer_ids'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback d-block"><?php echo e($message); ?></div>
                    <?php elseif($errors->has('shampooer_ids.*')): ?>
                        <div class="invalid-feedback d-block"><?php echo e($errors->first('shampooer_ids.*')); ?></div>
                    <?php else: ?>
                        <div class="invalid-feedback">Vui lòng chọn ít nhất một Nhân viên gội đầu</div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div class="form-group col-md-6">
                    <label for="receptionist_ids">Lễ tân <span class="text-danger">*</span></label>
                    <select name="receptionist_ids[]" id="receptionist_ids" class="form-control select2-multiple <?php $__errorArgs = ['receptionist_ids'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> <?php $__errorArgs = ['receptionist_ids.*'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" multiple required>
                        <?php $__currentLoopData = $receptionists; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $receptionist): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($receptionist->id); ?>" <?php echo e((old('receptionist_ids') && in_array($receptionist->id, old('receptionist_ids'))) ? 'selected' : ''); ?>>
                                <?php echo e($receptionist->user->name ?? 'N/A'); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <?php $__errorArgs = ['receptionist_ids'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback d-block"><?php echo e($message); ?></div>
                    <?php elseif($errors->has('receptionist_ids.*')): ?>
                        <div class="invalid-feedback d-block"><?php echo e($errors->first('receptionist_ids.*')); ?></div>
                    <?php else: ?>
                        <div class="invalid-feedback">Vui lòng chọn ít nhất một Lễ tân</div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>

            <div class="form-group">
                <button type="submit" class="btn btn-primary"><i class="fas fa-save"></i> Lưu</button>
                <a href="<?php echo e(route('admin.working-schedules.index')); ?>" class="btn btn-secondary">Hủy</a>
            </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
(function() {
    'use strict';
    window.addEventListener('load', function() {
        var forms = document.getElementsByClassName('needs-validation');
        Array.prototype.filter.call(forms, function(form) {
            form.addEventListener('submit', function(event) {
                if (form.checkValidity() === false) {
                    event.preventDefault();
                    event.stopPropagation();
                }
                form.classList.add('was-validated');
            }, false);
        });
    }, false);
})();

// Khởi tạo Select2 cho multi-select
$(document).ready(function() {
    // Select2 cho ca làm việc
    $('#shift_ids').select2({
        placeholder: 'Chọn ca làm việc',
        allowClear: false,
        width: '100%',
        closeOnSelect: false
    });

    // Select2 cho các vị trí nhân viên
    $('#stylist_ids, #barber_ids, #shampooer_ids, #receptionist_ids').select2({
        placeholder: 'Chọn nhân viên',
        allowClear: false,
        width: '100%',
        closeOnSelect: false
    });

    // ✅ MỚI: Nút chọn ca cả ngày (7h-22h)
    <?php if($fullDayShift): ?>
        const fullDayShiftId = '<?php echo e($fullDayShift->id); ?>';
        
        // Kiểm tra trạng thái ban đầu
        const initialValues = $('#shift_ids').val() || [];
        if (initialValues.includes(fullDayShiftId)) {
            $('#btn_full_day_shift').html('<i class="fas fa-check"></i> Đã chọn').removeClass('btn-info').addClass('btn-success');
        }
        
        $('#btn_full_day_shift').on('click', function() {
            const currentValues = $('#shift_ids').val() || [];
            
            // Nếu ca cả ngày chưa được chọn, thêm vào
            if (!currentValues.includes(fullDayShiftId)) {
                currentValues.push(fullDayShiftId);
                $('#shift_ids').val(currentValues).trigger('change');
                
                // Hiển thị thông báo
                $(this).html('<i class="fas fa-check"></i> Đã chọn').removeClass('btn-info').addClass('btn-success');
            } else {
                // Nếu đã chọn, bỏ chọn
                const newValues = currentValues.filter(id => id !== fullDayShiftId);
                $('#shift_ids').val(newValues).trigger('change');
                
                $(this).html('<i class="fas fa-calendar-day"></i> Ca cả ngày').removeClass('btn-success').addClass('btn-info');
            }
        });
    <?php endif; ?>

    // Cập nhật validation khi thay đổi ca làm việc
    $('#shift_ids').on('change', function() {
        const shiftCount = $('#shift_ids').val() ? $('#shift_ids').val().length : 0;
        
        if (shiftCount > 0) {
            $('#shift_ids')[0].setCustomValidity('');
        } else {
            $('#shift_ids')[0].setCustomValidity('Vui lòng chọn ít nhất một ca làm việc');
        }
        
        // ✅ MỚI: Cập nhật trạng thái nút "Ca cả ngày"
        <?php if($fullDayShift): ?>
            const currentValues = $('#shift_ids').val() || [];
            const isSelected = currentValues.includes(fullDayShiftId);
            
            if (isSelected) {
                $('#btn_full_day_shift').html('<i class="fas fa-check"></i> Đã chọn').removeClass('btn-info').addClass('btn-success');
            } else {
                $('#btn_full_day_shift').html('<i class="fas fa-calendar-day"></i> Ca cả ngày').removeClass('btn-success').addClass('btn-info');
            }
        <?php endif; ?>
    });

    // Cập nhật validation khi thay đổi nhân viên
    $('#stylist_ids, #barber_ids, #shampooer_ids, #receptionist_ids').on('change', function() {
        const employeeCount = $(this).val() ? $(this).val().length : 0;
        
        if (employeeCount > 0) {
            this.setCustomValidity('');
        } else {
            this.setCustomValidity('Vui lòng chọn ít nhất một nhân viên');
        }
    });
});

// Toggle hiển thị input theo loại lịch
function toggleScheduleType() {
    const scheduleType = $('input[name="schedule_type"]:checked').val();
    if (scheduleType === 'day') {
        $('#day_input_group').show();
        $('#week_input_group').hide();
        $('#work_date').prop('required', true);
        $('#week_start_date').prop('required', false);
    } else {
        $('#day_input_group').hide();
        $('#week_input_group').show();
        $('#work_date').prop('required', false);
        $('#week_start_date').prop('required', true);
    }
}

// Khởi tạo khi trang load
$(document).ready(function() {
    toggleScheduleType();
});

// Validation trước khi submit
function validateForm() {
    const stylistIds = $('#stylist_ids').val();
    const barberIds = $('#barber_ids').val();
    const shampooerIds = $('#shampooer_ids').val();
    const receptionistIds = $('#receptionist_ids').val();
    const shiftIds = $('#shift_ids').val();
    const shiftCount = shiftIds ? shiftIds.length : 0;
    
    const stylistCount = stylistIds ? stylistIds.length : 0;
    const barberCount = barberIds ? barberIds.length : 0;
    const shampooerCount = shampooerIds ? shampooerIds.length : 0;
    const receptionistCount = receptionistIds ? receptionistIds.length : 0;
    
    if (stylistCount === 0 || barberCount === 0 || shampooerCount === 0 || receptionistCount === 0) {
        alert('Vui lòng chọn ít nhất một nhân viên cho mỗi vị trí!');
        return false;
    }
    
    if (shiftCount === 0) {
        alert('Vui lòng chọn ít nhất một ca làm việc!');
        $('#shift_ids').select2('open');
        return false;
    }
    
    // Cho phép submit form mà không cần xác nhận
    return true;
}
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\laragon\www\polyhair\resources\views/admin/working-schedules/create.blade.php ENDPATH**/ ?>