<div class="service-detail">
    <div class="row">
        <div class="col-md-4">
            <?php if($service->image): ?>
                <img src="<?php echo e(asset('legacy/images/products/' . $service->image)); ?>" alt="<?php echo e($service->name); ?>" class="img-fluid rounded mb-3">
            <?php else: ?>
                <div class="bg-light rounded p-5 text-center mb-3">
                    <i class="fas fa-image fa-3x text-muted"></i>
                    <p class="text-muted mt-2">Không có ảnh</p>
                </div>
            <?php endif; ?>
        </div>
        <div class="col-md-8">
            <h4 class="mb-3"><?php echo e($service->name); ?></h4>
            <table class="table table-bordered">
                <tr>
                    <th width="30%">Mã dịch vụ:</th>
                    <td><?php echo e($service->service_code ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <th>Loại:</th>
                    <td>
                        <?php if($service->serviceVariants->count() > 0): ?>
                            <span class="badge badge-info">
                                <i class="fas fa-layer-group"></i> Dịch vụ biến thể (<?php echo e($service->serviceVariants->count()); ?> biến thể)
                            </span>
                        <?php else: ?>
                            <span class="badge badge-primary">
                                <i class="fas fa-tag"></i> Dịch vụ đơn
                            </span>
                        <?php endif; ?>
                    </td>
                </tr>
                <tr>
                    <th>Nhóm dịch vụ:</th>
                    <td><?php echo e($service->category->name ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <th>Giá:</th>
                    <td>
                        <?php if($service->base_price): ?>
                            <strong class="text-primary"><?php echo e(number_format($service->base_price, 0, ',', '.')); ?> đ</strong>
                        <?php elseif($service->serviceVariants->count() > 0): ?>
                            <?php
                                $minPrice = $service->serviceVariants->min('price');
                                $maxPrice = $service->serviceVariants->max('price');
                            ?>
                            <?php if($minPrice == $maxPrice): ?>
                                <strong class="text-primary"><?php echo e(number_format($minPrice, 0, ',', '.')); ?> đ</strong>
                            <?php else: ?>
                                <strong class="text-primary"><?php echo e(number_format($minPrice, 0, ',', '.')); ?> - <?php echo e(number_format($maxPrice, 0, ',', '.')); ?> đ</strong>
                            <?php endif; ?>
                        <?php else: ?>
                            N/A
                        <?php endif; ?>
                    </td>
                </tr>
                <tr>
                    <th>Trạng thái:</th>
                    <td>
                        <span class="badge badge-<?php echo e($service->status == 'Hoạt động' ? 'success' : 'secondary'); ?>">
                            <?php echo e($service->status); ?>

                        </span>
                    </td>
                </tr>
                <?php if($service->description): ?>
                <tr>
                    <th>Mô tả:</th>
                    <td><?php echo e($service->description); ?></td>
                </tr>
                <?php endif; ?>
            </table>
        </div>
    </div>

    <?php if($service->serviceVariants->count() > 0): ?>
    <div class="mt-4">
        <h5 class="mb-3">
            <i class="fas fa-layer-group"></i> Danh sách biến thể (<?php echo e($service->serviceVariants->count()); ?>)
        </h5>
        <div class="table-responsive">
            <table class="table table-bordered table-sm">
                <thead class="thead-light">
                    <tr>
                        <th>Tên biến thể</th>
                        <th>Giá</th>
                        <th>Thời lượng</th>
                        <th>Thuộc tính</th>
                        <th>Trạng thái</th>
                        <th>Ghi chú</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $service->serviceVariants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $variant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td>
                                <strong><?php echo e($variant->name); ?></strong>
                                <?php if($variant->is_default): ?>
                                    <span class="badge badge-warning">Mặc định</span>
                                <?php endif; ?>
                            </td>
                            <td><strong class="text-primary"><?php echo e(number_format($variant->price, 0, ',', '.')); ?> đ</strong></td>
                            <td><?php echo e($variant->duration); ?> phút</td>
                            <td>
                                <?php if($variant->variantAttributes->count() > 0): ?>
                                    <?php $__currentLoopData = $variant->variantAttributes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attr): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <span class="badge badge-secondary mr-1">
                                            <?php echo e($attr->attribute_name); ?>: <?php echo e($attr->attribute_value); ?>

                                        </span>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php else: ?>
                                    <span class="text-muted">Không có</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <span class="badge badge-<?php echo e($variant->is_active ? 'success' : 'secondary'); ?>">
                                    <?php echo e($variant->is_active ? 'Hoạt động' : 'Vô hiệu hóa'); ?>

                                </span>
                            </td>
                            <td><?php echo e($variant->notes ?? '-'); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
    <?php endif; ?>
</div>

<?php /**PATH E:\laragon\www\polyhair\resources\views/admin/services/partials/service_detail.blade.php ENDPATH**/ ?>