<?php $__env->startSection('title', 'Quản lý đơn đặt'); ?>

<?php $__env->startSection('content'); ?>
<!-- Page Heading -->
<div class="d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h3 mb-0 text-gray-800">Quản lý đơn đặt</h1>
</div>

    <!-- Filter -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Tìm kiếm và lọc</h6>
        </div>
        <div class="card-body">
            <form method="GET" action="<?php echo e(route('employee.appointments.index')); ?>" class="form-row">
                <div class="form-group col-md-3">
                    <label for="customer_name">Tên khách hàng:</label>
                    <input type="text" name="customer_name" id="customer_name" class="form-control"
                        value="<?php echo e($filters['customer_name'] ?? ''); ?>" placeholder="Nhập tên khách hàng">
                </div>
                <div class="form-group col-md-3">
                    <label for="phone">Số điện thoại:</label>
                    <input type="text" name="phone" id="phone" class="form-control" value="<?php echo e($filters['phone'] ?? ''); ?>"
                        placeholder="Nhập số điện thoại">
                </div>
                <div class="form-group col-md-2">
                    <label for="date">Ngày đặt:</label>
                    <input type="date" name="date" id="date" class="form-control" value="<?php echo e($filters['date'] ?? ''); ?>">
                </div>
                <div class="form-group col-md-2">
                    <label for="status">Trạng thái:</label>
                    <select name="status" id="status" class="form-control">
                        <option value="">Tất cả</option>
                        <option value="Chờ xử lý" <?php echo e(($filters['status'] ?? '') == 'Chờ xử lý' ? 'selected' : ''); ?>>Chờ xử lý
                        </option>
                        <option value="Chờ xác nhận" <?php echo e(($filters['status'] ?? '') == 'Chờ xác nhận' ? 'selected' : ''); ?>>Chờ
                            xác nhận</option>
                        <option value="Đã xác nhận" <?php echo e(($filters['status'] ?? '') == 'Đã xác nhận' ? 'selected' : ''); ?>>Đã xác
                            nhận</option>
                        <option value="Đang thực hiện" <?php echo e(($filters['status'] ?? '') == 'Đang thực hiện' ? 'selected' : ''); ?>>
                            Đang thực hiện</option>
                        <option value="Hoàn thành" <?php echo e(($filters['status'] ?? '') == 'Hoàn thành' ? 'selected' : ''); ?>>Hoàn
                            thành</option>
                        <option value="Đã hủy" <?php echo e(($filters['status'] ?? '') == 'Đã hủy' ? 'selected' : ''); ?>>Đã hủy</option>
                    </select>
                </div>
                <div class="form-group col-md-2 d-flex align-items-end">
                    <button type="submit" class="btn btn-primary mr-2">
                        <i class="fas fa-search"></i> Tìm kiếm
                    </button>
                    <a href="<?php echo e(route('employee.appointments.index')); ?>" class="btn btn-secondary">
                        <i class="fas fa-redo"></i> Làm mới
                    </a>
                </div>
            </form>
        </div>
    </div>

    <!-- DataTales Example -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Danh sách đơn đặt</h6>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>Mã đơn đặt</th>
                            <th>Tên khách hàng</th>
                            <th>Số điện thoại</th>
                            <th>Dịch vụ</th>
                            <th>Ngày và giờ</th>
                            <th>Trạng thái</th>
                            <th>Thao tác</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $appointments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $appointment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr>
                                            <td><?php echo e($appointment->booking_code ?? 'N/A'); ?></td>
                                            <td><?php echo e($appointment->user->name ?? $appointment->guest_name ?? 'N/A'); ?></td>
                                            <td><?php echo e($appointment->user->phone ?? $appointment->guest_phone ?? 'N/A'); ?></td>
                                            <td>
                                                <?php if($appointment->appointmentDetails->count() > 0): ?>
                                                    <?php $__currentLoopData = $appointment->appointmentDetails->take(2); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php if($detail->combo_id && $detail->combo): ?>
                                                            <span class="badge badge-info">
                                                                <?php echo e($detail->combo->name ?? ($detail->notes ?? 'Combo')); ?>

                                                            </span>
                                                        <?php elseif($detail->serviceVariant && $detail->serviceVariant->service): ?>
                                                            <span class="badge badge-info">
                                                                <?php echo e($detail->serviceVariant->service->name); ?>

                                                            </span>
                                                        <?php elseif($detail->notes): ?>
                                                            <span class="badge badge-info">
                                                                <?php echo e($detail->notes); ?>

                                                            </span>
                                                        <?php else: ?>
                                                            <span class="badge badge-secondary">Dịch vụ</span>
                                                        <?php endif; ?>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php if($appointment->appointmentDetails->count() > 2): ?>
                                                        <span class="badge badge-secondary">
                                                            +<?php echo e($appointment->appointmentDetails->count() - 2); ?> khác
                                                        </span>
                                                    <?php endif; ?>
                                                <?php else: ?>
                                                    <span class="text-muted">Chưa có dịch vụ</span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php if($appointment->start_at): ?>
                                                    <?php echo e($appointment->start_at->format('d/m/Y H:i')); ?>

                                                <?php else: ?>
                                                    <span class="text-muted">Chưa có</span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <span class="badge badge-<?php echo e($appointment->status == 'Hoàn thành' ? 'success' :
                            ($appointment->status == 'Đã hủy' ? 'danger' :
                                ($appointment->status == 'Đã xác nhận' || $appointment->status == 'Đang thực hiện' ? 'info' : 'warning'))); ?>">
                                                    <?php echo e($appointment->status); ?>

                                                </span>
                                            </td>
                                            <td>
                                                <div class="d-flex flex-wrap gap-1">
                                                    <a href="<?php echo e(route('employee.appointments.show', $appointment->id)); ?>"
                                                        class="btn btn-sm btn-info" title="Xem chi tiết">
                                                        <i class="fas fa-eye"></i>
                                                    </a>

                                                    <?php if($appointment->status == 'Hoàn thành' || $appointment->status == 'Chưa thanh toán'): ?>
                                                        <a href="<?php echo e(route('employee.appointments.checkout', ['appointment_id' => $appointment->id])); ?>" class="btn btn-sm btn-success" title="Thanh toán">
                                                            <i class="fas fa-money-bill-wave"></i>
                                                        </a>
                                                    <?php endif; ?>

                                                    <?php if(isset($employee) && $employee && $employee->position === 'Receptionist'): ?>
                                                        <a href="<?php echo e(route('employee.appointments.edit', $appointment->id)); ?>"
                                                            class="btn btn-sm btn-warning" title="Sửa lịch hẹn">
                                                            <i class="fas fa-edit"></i> Sửa
                                                        </a>
                                                    <?php endif; ?>

                                                    <?php if($appointment->status == 'Chờ xác nhận' || $appointment->status == 'Chờ xử lý'): ?>
                                                        <form action="<?php echo e(route('employee.appointments.confirm', $appointment->id)); ?>"
                                                            method="POST" class="d-inline">
                                                            <?php echo csrf_field(); ?>
                                                            <button type="submit" class="btn btn-sm btn-success" title="Xác nhận đơn">
                                                                <i class="fas fa-check"></i> Xác nhận
                                                            </button>
                                                        </form>
                                                        <button type="button" class="btn btn-sm btn-danger" title="Hủy đơn" data-toggle="modal"
                                                            data-target="#cancelModal<?php echo e($appointment->id); ?>">
                                                            <i class="fas fa-times"></i> Hủy
                                                        </button>
                                                    <?php endif; ?>

                                                    <?php if($appointment->status == 'Đã xác nhận'): ?>
                                                        <form action="<?php echo e(route('employee.appointments.start', $appointment->id)); ?>"
                                                            method="POST" class="d-inline">
                                                            <?php echo csrf_field(); ?>
                                                            <button type="submit" class="btn btn-sm btn-info" title="Bắt đầu thực hiện"
                                                                onclick="return confirm('Bạn có chắc chắn muốn bắt đầu thực hiện đơn đặt này?');">
                                                                <i class="fas fa-play"></i> Bắt đầu
                                                            </button>
                                                        </form>
                                                    <?php endif; ?>

                                                    <?php if($appointment->status == 'Đang thực hiện'): ?>
                                                        <form action="<?php echo e(route('employee.appointments.complete', $appointment->id)); ?>"
                                                            method="POST" class="d-inline">
                                                            <?php echo csrf_field(); ?>
                                                            <button type="submit" class="btn btn-sm btn-success" title="Hoàn thành"
                                                                onclick="return confirm('Bạn có chắc chắn muốn hoàn thành đơn đặt này?');">
                                                                <i class="fas fa-check-circle"></i> Hoàn thành
                                                            </button>
                                                        </form>
                                                    <?php endif; ?>
                                                </div>
                                            </td>
                                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="7" class="text-center">
                                    <?php
                                        $hasFilters = !empty($filters['customer_name']) ||
                                            !empty($filters['phone']) ||
                                            !empty($filters['date']) ||
                                            !empty($filters['status']);
                                        $activeFilters = [];
                                        if (!empty($filters['customer_name'])) {
                                            $activeFilters[] = 'tên khách hàng "' . $filters['customer_name'] . '"';
                                        }
                                        if (!empty($filters['phone'])) {
                                            $activeFilters[] = 'số điện thoại "' . $filters['phone'] . '"';
                                        }
                                        if (!empty($filters['date'])) {
                                            $activeFilters[] = 'ngày "' . \Carbon\Carbon::parse($filters['date'])->format('d/m/Y') . '"';
                                        }
                                        if (!empty($filters['status'])) {
                                            $activeFilters[] = 'trạng thái "' . $filters['status'] . '"';
                                        }
                                    ?>

                                    <?php if($hasFilters): ?>
                                        <div class="alert alert-info mb-0">
                                            <i class="fas fa-info-circle"></i>
                                            <strong>Không tìm thấy đơn đặt nào</strong>
                                            <?php if(count($activeFilters) > 0): ?>
                                                <br>
                                                <small>Với <?php echo e(implode(', ', $activeFilters)); ?></small>
                                            <?php endif; ?>
                                        </div>
                                    <?php else: ?>
                                        <div class="text-muted">Chưa có đơn đặt nào</div>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            <?php if($appointments->hasPages()): ?>
                <div class="d-flex justify-content-between align-items-center mt-4 flex-wrap">
                    <div class="text-muted mb-2 mb-md-0">
                        Hiển thị <?php echo e($appointments->firstItem()); ?> đến <?php echo e($appointments->lastItem()); ?> trong tổng số
                        <?php echo e($appointments->total()); ?> kết quả
                    </div>
                    <div>
                        <?php echo e($appointments->appends(request()->except('page'))->links('pagination::bootstrap-4')); ?>

                    </div>
                </div>
            <?php elseif($appointments->total() > 0): ?>
                <div class="d-flex justify-content-between align-items-center mt-4 flex-wrap">
                    <div class="text-muted mb-2 mb-md-0">
                        Hiển thị <?php echo e($appointments->firstItem()); ?> đến <?php echo e($appointments->lastItem()); ?> trong tổng số
                        <?php echo e($appointments->total()); ?> kết quả
                    </div>
                    <div>
                        <!-- No pagination needed for single page -->
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Cancel Modals for each appointment -->
    <?php $__currentLoopData = $appointments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $appointment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php if($appointment->status == 'Chờ xác nhận' || $appointment->status == 'Chờ xử lý'): ?>
            <div class="modal fade" id="cancelModal<?php echo e($appointment->id); ?>" tabindex="-1" role="dialog"
                aria-labelledby="cancelModalLabel<?php echo e($appointment->id); ?>" aria-hidden="true">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <form action="<?php echo e(route('employee.appointments.cancel', $appointment->id)); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <div class="modal-header">
                                <h5 class="modal-title" id="cancelModalLabel<?php echo e($appointment->id); ?>">Hủy đơn đặt
                                    #<?php echo e($appointment->booking_code ?? $appointment->id); ?></h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                            <div class="modal-body">
                                <div class="form-group">
                                    <label for="cancellation_reason<?php echo e($appointment->id); ?>">Lý do hủy <span
                                            class="text-danger">*</span></label>
                                    <textarea name="cancellation_reason" id="cancellation_reason<?php echo e($appointment->id); ?>"
                                        class="form-control <?php $__errorArgs = ['cancellation_reason'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" rows="4" required
                                        placeholder="Nhập lý do hủy đơn..."><?php echo e(old('cancellation_reason')); ?></textarea>
                                    <?php $__errorArgs = ['cancellation_reason'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Đóng</button>
                                <button type="submit" class="btn btn-danger">Xác nhận hủy</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
    <style>
        .pagination {
            margin-bottom: 0;
        }

        .pagination .page-link {
            color: #5a5c69;
            border-color: #d1d3e2;
        }

        .pagination .page-item.active .page-link {
            background-color: #4e73df;
            border-color: #4e73df;
        }

        .pagination .page-link:hover {
            color: #4e73df;
            background-color: #eaecf4;
            border-color: #d1d3e2;
        }

        .pagination .disabled .page-link {
            color: #858796;
            background-color: #fff;
            border-color: #d1d3e2;
        }

        .gap-1 {
            gap: 0.25rem;
        }

        .gap-1>* {
            margin-right: 0.25rem;
            margin-bottom: 0.25rem;
        }

        .gap-1 form {
            display: inline-block;
            margin-right: 0.25rem;
            margin-bottom: 0.25rem;
        }

        .gap-1 button,
        .gap-1 a {
            white-space: nowrap;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        $(document).ready(function () {
            // Auto-submit form on date change
            $('#date').on('change', function () {
                // Optional: auto-submit if needed
            });
        });
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\laragon\www\polyhair\resources\views/admin/employee-appointments/index.blade.php ENDPATH**/ ?>