<?php $__env->startSection('title', 'Quản lý nhân viên'); ?>

<?php $__env->startSection('content'); ?>
<!-- Page Heading -->
<div class="d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h3 mb-0 text-gray-800">Quản lý nhân viên</h1>
    <?php if(auth()->user()->isAdmin()): ?>
        <a href="<?php echo e(route('admin.employees.create')); ?>" class="btn btn-primary">
            <i class="fas fa-plus"></i> Thêm mới
        </a>
    <?php endif; ?>
</div>

<!-- Filter -->
<div class="card shadow mb-4">
    <div class="card-header py-3 d-flex justify-content-between align-items-center">
        <h6 class="m-0 font-weight-bold text-primary">Lọc nhân viên</h6>
        <?php if(auth()->user()->isAdmin()): ?>
            <a href="<?php echo e(route('admin.employees.trash')); ?>" class="btn btn-warning btn-sm">
                <i class="fas fa-trash"></i> Thùng rác
            </a>
        <?php endif; ?>
    </div>
    <div class="card-body">
        <form method="GET" action="<?php echo e(route('admin.employees.index')); ?>" class="form-inline">
            <div class="form-group mr-3">
                <input type="text" name="keyword" class="form-control" placeholder="Tìm kiếm theo tên..." value="<?php echo e(request('keyword')); ?>">
            </div>
            <div class="form-group mr-3">
                <select name="position" class="form-control">
                    <option value="">Tất cả vị trí</option>
                    <option value="Stylist" <?php echo e(request('position') == 'Stylist' ? 'selected' : ''); ?>>Thợ tạo kiểu</option>
                    <option value="Barber" <?php echo e(request('position') == 'Barber' ? 'selected' : ''); ?>>Thợ cắt tóc nam</option>
                    <option value="Shampooer" <?php echo e(request('position') == 'Shampooer' ? 'selected' : ''); ?>>Nhân viên gội đầu</option>
                    <option value="Receptionist" <?php echo e(request('position') == 'Receptionist' ? 'selected' : ''); ?>>Lễ tân</option>
                </select>
            </div>
            <div class="form-group mr-3">
                <select name="status" class="form-control">
                    <option value="">Tất cả trạng thái</option>
                    <option value="Đang làm việc" <?php echo e(request('status') == 'Đang làm việc' ? 'selected' : ''); ?>>Đang làm việc</option>
                    <option value="Nghỉ phép" <?php echo e(request('status') == 'Nghỉ phép' ? 'selected' : ''); ?>>Nghỉ phép</option>
                    <option value="Vô hiệu hóa" <?php echo e(request('status') == 'Vô hiệu hóa' ? 'selected' : ''); ?>>Vô hiệu hóa</option>
                </select>
            </div>
            <button type="submit" class="btn btn-primary">
                <i class="fas fa-filter"></i> Lọc
            </button>
            <a href="<?php echo e(route('admin.employees.index')); ?>" class="btn btn-secondary ml-2">
                <i class="fas fa-redo"></i> Làm mới
            </a>
        </form>
    </div>
</div>

<!-- DataTales Example -->
<div class="card shadow mb-4">
    <div class="card-header py-3">
        <h6 class="m-0 font-weight-bold text-primary">Danh sách nhân viên</h6>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                <thead>
                    <tr>
                        <th>Mã NV</th>
                        <th>Tên nhân viên</th>
                        <th>Email</th>
                        <th>Vị trí</th>
                        <th>Cấp độ</th>
                        <th>Trạng thái</th>
                        <th>Thao tác</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($employee->id); ?></td>
                            <td><?php echo e($employee->user->name ?? 'N/A'); ?></td>
                            <td><?php echo e($employee->user->email ?? 'N/A'); ?></td>
                            <td><?php echo e(\App\Models\Employee::getPositionVietnamese($employee->position ?? '') ?: 'N/A'); ?></td>
                            <td><?php echo e($employee->level ?? 'N/A'); ?></td>
                            <td>
                                <span class="badge badge-<?php echo e($employee->status == 'Đang làm việc' ? 'success' : ($employee->status == 'Nghỉ phép' ? 'warning' : 'secondary')); ?>">
                                    <?php echo e($employee->status); ?>

                                </span>
                            </td>
                            <td class="text-center">
                                <div class="d-flex gap-1 justify-content-center">
                                    <a href="<?php echo e(route('admin.employees.show', $employee->id)); ?>" class="btn btn-sm btn-info" title="Xem chi tiết">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                    <?php if(auth()->user()->isAdmin()): ?>
                                        <a href="<?php echo e(route('admin.employees.edit', $employee->id)); ?>" class="btn btn-sm btn-primary" title="Sửa thông tin">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <form action="<?php echo e(route('admin.employees.destroy', $employee->id)); ?>" method="POST" class="d-inline" onsubmit="return confirmDelete('<?php echo e($employee->user->name ?? 'Nhân viên'); ?>');">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-sm btn-danger" title="Xóa nhân viên">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="7" class="text-center">Chưa có nhân viên nào</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .gap-1 {
        gap: 0.25rem;
    }
    .gap-1 > * {
        margin-right: 0.25rem;
        margin-bottom: 0.25rem;
    }
    .gap-1 form {
        display: inline-block;
        margin-right: 0.25rem;
        margin-bottom: 0.25rem;
    }
    .gap-1 button, .gap-1 a {
        white-space: nowrap;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    $(document).ready(function() {
        $('#dataTable').DataTable({
            "language": {
                "url": "//cdn.datatables.net/plug-ins/1.10.24/i18n/Vietnamese.json"
            }
        });
    });

    function confirmDelete(employeeName) {
        const today = new Date();
        const dateStr = today.toLocaleDateString('vi-VN', { 
            day: '2-digit', 
            month: '2-digit', 
            year: 'numeric' 
        });
        return confirm('Bạn có chắc chắn muốn xóa tài khoản nhân viên "' + employeeName + '" vào ngày ' + dateStr + ' hay không?');
    }
</script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\laragon\www\polyhair\resources\views/admin/employees/index.blade.php ENDPATH**/ ?>