<?php if($items->hasPages()): ?>
<div class="d-flex justify-content-center mt-4">
  <nav aria-label="Service pagination">
    <ul class="pagination service-pagination">
      
      <?php if($items->onFirstPage()): ?>
        <li class="page-item disabled" aria-disabled="true">
          <span class="page-link" aria-hidden="true">&lsaquo; Trước</span>
        </li>
      <?php else: ?>
        <li class="page-item">
          <a class="page-link" href="<?php echo e($items->previousPageUrl()); ?>" rel="prev" data-ajax-pagination>&lsaquo; Trước</a>
        </li>
      <?php endif; ?>

      
      <?php $__currentLoopData = $items->getUrlRange(1, $items->lastPage()); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page => $url): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php if($page == $items->currentPage()): ?>
          <li class="page-item active" aria-current="page">
            <span class="page-link"><?php echo e($page); ?></span>
          </li>
        <?php else: ?>
          <li class="page-item">
            <a class="page-link" href="<?php echo e($url); ?>" data-ajax-pagination><?php echo e($page); ?></a>
          </li>
        <?php endif; ?>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

      
      <?php if($items->hasMorePages()): ?>
        <li class="page-item">
          <a class="page-link" href="<?php echo e($items->nextPageUrl()); ?>" rel="next" data-ajax-pagination>Sau &rsaquo;</a>
        </li>
      <?php else: ?>
        <li class="page-item disabled" aria-disabled="true">
          <span class="page-link" aria-hidden="true">Sau &rsaquo;</span>
        </li>
      <?php endif; ?>
    </ul>
  </nav>
</div>
<?php endif; ?>

<?php /**PATH C:\laragon\www\PolyHair\resources\views/site/partials/service-pagination.blade.php ENDPATH**/ ?>