<?php $__env->startSection('title', 'Chi tiết lịch hẹn'); ?>

<?php $__env->startSection('content'); ?>
<!-- Page Heading -->
<div class="d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h3 mb-0 text-gray-800">Chi tiết lịch hẹn <?php echo e($appointment->booking_code ?? '#' . $appointment->id); ?></h1>
    <a href="<?php echo e(route('admin.appointments.index')); ?>" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> Quay lại
    </a>
</div>

<!-- Appointment Info -->
<div class="card shadow mb-4">
    <div class="card-header py-3">
        <h6 class="m-0 font-weight-bold text-primary">Thông tin lịch hẹn</h6>
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-md-6">
                <div class="form-group">
                    <label>Khách hàng:</label>
                    <p class="form-control-plaintext"><?php echo e($appointment->user->name ?? $appointment->guest_name ?? 'N/A'); ?></p>
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label>Nhân viên:</label>
                    <p class="form-control-plaintext"><?php echo e($appointment->employee->user->name ?? 'Chưa phân công'); ?></p>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-6">
                <div class="form-group">
                    <label>Thời gian bắt đầu:</label>
                    <p class="form-control-plaintext"><?php echo e($appointment->start_at ? $appointment->start_at->format('d/m/Y H:i') : 'N/A'); ?></p>
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label>Thời gian kết thúc:</label>
                    <p class="form-control-plaintext"><?php echo e($appointment->end_at ? $appointment->end_at->format('d/m/Y H:i') : 'N/A'); ?></p>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-6">
                <div class="form-group">
                    <label>Trạng thái:</label>
                    <div>
                        <span class="badge badge-<?php echo e($appointment->status == 'Hoàn thành' ? 'success' : ($appointment->status == 'Đã hủy' ? 'danger' : ($appointment->status == 'Đã xác nhận' ? 'info' : ($appointment->status == 'Đã thanh toán' ? 'success' : 'warning')))); ?> badge-lg" style="font-size: 14px; padding: 8px 12px;">
                            <?php echo e($appointment->status); ?>

                        </span>
                    </div>
                    <small class="form-text text-muted">Trạng thái chỉ có thể thay đổi ở trang chỉnh sửa</small>
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label>Mã đơn:</label>
                    <p class="form-control-plaintext">
                        <strong><?php echo e($appointment->booking_code ?? '#' . str_pad($appointment->id, 6, '0', STR_PAD_LEFT)); ?></strong>
                    </p>
                </div>
            </div>
        </div>

        <?php if($appointment->note): ?>
        <div class="form-group">
            <label>Ghi chú:</label>
            <p class="form-control-plaintext"><?php echo e($appointment->note); ?></p>
        </div>
        <?php endif; ?>

        <?php if($appointment->cancellation_reason): ?>
        <div class="form-group">
            <label>Lý do hủy:</label>
            <p class="form-control-plaintext text-danger"><?php echo e($appointment->cancellation_reason); ?></p>
        </div>
        <?php endif; ?>

        <div class="form-group">
            <a href="<?php echo e(route('admin.appointments.edit', $appointment->id)); ?>" class="btn btn-primary">
                <i class="fas fa-edit"></i> Chỉnh sửa lịch hẹn
            </a>
            <?php if($appointment->status == 'Hoàn thành' || $appointment->status == 'Chưa thanh toán'): ?>
            <a href="<?php echo e(route('admin.appointments.checkout', ['appointment_id' => $appointment->id])); ?>" class="btn btn-success">
                <i class="fas fa-money-bill-wave"></i> Thanh toán
            </a>
            <?php endif; ?>
            <a href="<?php echo e(route('admin.appointments.index')); ?>" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Quay lại
            </a>
        </div>
    </div>
</div>

<!-- Appointment Details -->
<div class="card shadow mb-4">
    <div class="card-header py-3">
        <h6 class="m-0 font-weight-bold text-primary">Chi tiết dịch vụ</h6>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>Dịch vụ</th>
                        <th>Biến thể</th>
                        <th>Giá</th>
                        <th>Thời lượng (phút)</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $appointment->appointmentDetails; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td>
                                <?php if($detail->combo_id): ?>
                                    <?php echo e($detail->combo->name ?? ($detail->notes ?? 'Combo')); ?>

                                <?php elseif($detail->serviceVariant): ?>
                                    <?php echo e($detail->serviceVariant->service->name ?? 'N/A'); ?>

                                <?php else: ?>
                                    <?php echo e($detail->notes ?? 'Dịch vụ đơn'); ?>

                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($detail->combo_id): ?>
                                    <span class="badge badge-secondary">Combo</span>
                                <?php elseif($detail->serviceVariant): ?>
                                    <?php echo e($detail->serviceVariant->name ?? 'N/A'); ?>

                                <?php else: ?>
                                    <span class="badge badge-primary">Dịch vụ đơn</span>
                                <?php endif; ?>
                            </td>
                            <td><?php echo e(number_format($detail->price_snapshot ?? 0, 0, ',', '.')); ?> đ</td>
                            <td><?php echo e($detail->duration ?? 0); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="4" class="text-center">Chưa có dịch vụ nào</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\laragon\www\polyhair\resources\views/admin/appointments/show.blade.php ENDPATH**/ ?>