<?php
    // TODO: Implement slider service when library/slider model is created
    // Default slider data if no sliders are provided
    $sliders = $sliders ?? [];
    
    // If no sliders, use default with actual image
    if (count($sliders) == 0) {
        $sliders = [
            [
                'name' => 'Chăm sóc chuyên nghiệp',
                'images' => 'banner.png',
                'description' => 'Dịch vụ chăm sóc tóc và làm đẹp hàng đầu'
            ]
        ];
    }
?>

<?php if(count($sliders) > 0): ?>
<!-- slider_area_start -->
<div class="slider_area" style="margin-top: 80px;">
    <div class="container-fluid p-0">
        <div id="carouselExampleControls" class="carousel slide" data-ride="carousel">
            <div class="carousel-inner">
                <?php $__currentLoopData = $sliders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $slider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="carousel-item <?php echo e($index == 0 ? 'active' : ''); ?>">
                        <div class="overlay2">
                            <?php
                                $imagePath = isset($slider['images']) ? 'legacy/images/sliders/' . $slider['images'] : null;
                                // Check if image exists, if not try to use a default one
                                $imageExists = false;
                                if ($imagePath && file_exists(public_path($imagePath))) {
                                    $imageExists = true;
                                } elseif ($imagePath) {
                                    // Try alternative images if the specified one doesn't exist
                                    $altImages = ['banner.png', '1.png', 'banner_service.png', 'bradcam.png'];
                                    foreach ($altImages as $altImg) {
                                        $altPath = 'legacy/images/sliders/' . $altImg;
                                        if (file_exists(public_path($altPath))) {
                                            $imagePath = $altPath;
                                            $imageExists = true;
                                            break;
                                        }
                                    }
                                }
                            ?>
                            
                            <?php if($imageExists): ?>
                                <img class="slider-img img-fluid d-block w-100" src="<?php echo e(asset($imagePath)); ?>" alt="<?php echo e($slider['name'] ?? 'Slider'); ?>">
                                <div class="slider_text text-center">
                                    <h3 class=""><?php echo e($slider['name'] ?? 'Chăm sóc chuyên nghiệp'); ?></h3>
                                    <p><?php echo e($slider['description'] ?? 'Dịch vụ chăm sóc tóc và làm đẹp hàng đầu'); ?></p>
                                    <div class="book_room">
                                        <div class="book_btn d-lg-block">
                                            <a href="<?php echo e(route('site.appointment.create')); ?>">Đặt lịch ngay</a>
                                        </div>
                                    </div>
                                </div>
                            <?php else: ?>
                                <!-- Placeholder background if image doesn't exist -->
                                <div class="slider-placeholder">
                                    <div class="slider_text text-center slider-text-wrapper">
                                        <h3 class="text-white"><?php echo e($slider['name'] ?? 'Chăm sóc chuyên nghiệp'); ?></h3>
                                        <p class="text-white"><?php echo e($slider['description'] ?? 'Dịch vụ chăm sóc tóc và làm đẹp hàng đầu'); ?></p>
                                        <div class="book_room">
                                            <div class="book_btn d-lg-block">
                                                <a href="<?php echo e(route('site.appointment.create')); ?>">Đặt lịch ngay</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            <?php if(count($sliders) > 1): ?>
            <a class="carousel-control-prev" href="#carouselExampleControls" role="button" data-slide="prev">
                <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                <span class="sr-only">Previous</span>
            </a>
            <a class="carousel-control-next" href="#carouselExampleControls" role="button" data-slide="next">
                <span class="carousel-control-next-icon" aria-hidden="true"></span>
                <span class="sr-only">Next</span>
            </a>
            <?php endif; ?>
        </div>
    </div>
</div>
<!-- slider_area_end -->
<?php endif; ?>

<style>
    /* Căn giữa nút Đặt lịch ngay trong banner */
    .slider_area .slider_text .book_room {
        display: flex;
        justify-content: center;
        align-items: center;
        width: 100%;
    }
    
    .slider_area .slider_text .book_btn {
        display: flex;
        justify-content: center;
        align-items: center;
    }
    
    /* Giữ chữ "Chăm sóc chuyên nghiệp" trên 1 dòng */
    .slider_area .slider_text h3 {
        white-space: nowrap;
    }
</style>

<?php /**PATH C:\laragon\www\PolyHair\resources\views/site/partials/slider.blade.php ENDPATH**/ ?>