<?php $__env->startSection('title', 'Quản lý khuyến mãi'); ?>

<?php $__env->startSection('content'); ?>
<div class="d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h3 mb-0 text-gray-800">Quản lý khuyến mãi</h1>
    <div>
        <?php if(isset($isTrash) && $isTrash): ?>
            <a href="<?php echo e(route('admin.promotions.index')); ?>" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Quay lại
            </a>
        <?php else: ?>
            <a href="<?php echo e(route('admin.promotions.trash')); ?>" class="btn btn-warning">
                <i class="fas fa-trash-restore"></i> Thùng rác
            </a>
            <a href="<?php echo e(route('admin.promotions.create')); ?>" class="btn btn-primary">
                <i class="fas fa-plus"></i> Thêm khuyến mãi
            </a>
        <?php endif; ?>
    </div>
</div>

<div class="card shadow mb-4">
    <div class="card-header py-3">
        <h6 class="m-0 font-weight-bold text-primary">
            <?php if(isset($isTrash) && $isTrash): ?>
                Khuyến mãi đã xóa
            <?php else: ?>
                Danh sách khuyến mãi
            <?php endif; ?>
        </h6>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-bordered" id="promotionsTable" width="100%" cellspacing="0">
                <thead>
                    <tr>
                        <th>Mã KM</th>
                        <th>Tên</th>
                        <th>Giảm giá</th>
                        <th>Phạm vi áp dụng</th>
                        <th>Thời gian áp dụng</th>
                        <th>Trạng thái</th>
                        <th>Thao tác</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $promotions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $promotion): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($promotion->code); ?></td>
                            <td><?php echo e($promotion->name); ?></td>
                            <td>
                                <?php
                                    if ($promotion->discount_type === 'percent') {
                                        $discountText = $promotion->discount_percent !== null
                                            ? $promotion->discount_percent . '%'
                                            : '-';
                                    } else {
                                        $discountText = $promotion->discount_amount !== null
                                            ? number_format($promotion->discount_amount, 0, ',', '.') . ' đ'
                                            : '-';
                                    }
                                ?>
                                <?php echo e($discountText); ?>

                            </td>
                            <td>
                                <?php if($promotion->apply_scope === 'order'): ?>
                                    <div class="small">
                                        <span class="badge badge-primary">Theo hóa đơn</span>
                                        <?php if($promotion->min_order_amount): ?>
                                            <div>Hóa đơn từ <?php echo e(number_format($promotion->min_order_amount, 0, ',', '.')); ?> đ</div>
                                        <?php endif; ?>
                                        <?php if($promotion->max_discount_amount && $promotion->discount_type === 'percent'): ?>
                                            <div>Giảm tối đa <?php echo e(number_format($promotion->max_discount_amount, 0, ',', '.')); ?> đ</div>
                                        <?php endif; ?>
                                    </div>
                                <?php elseif($promotion->apply_scope === 'customer_tier'): ?>
                                    <div class="small">
                                        <span class="badge badge-warning">Theo hạng khách hàng</span>
                                        <div>
                                            Áp dụng cho khách từ hạng 
                                            <strong><?php echo e($promotion->min_customer_tier ?? 'Khách thường'); ?></strong> trở lên
                                        </div>
                                        <div class="text-muted">
                                            Giảm trực tiếp trên giá trị hóa đơn khi khách thanh toán.
                                        </div>
                                    </div>
                                <?php else: ?>
                                    <?php
                                        $servicesCount = $promotion->services->count();
                                        $combosCount = $promotion->combos->count();
                                        $variantsCount = $promotion->serviceVariants->count();
                                        $totalItems = $servicesCount + $combosCount + $variantsCount;
                                    ?>
                                    
                                    <?php if($totalItems > 0): ?>
                                        <div class="small">
                                            <?php if($servicesCount > 0): ?>
                                                <?php $__currentLoopData = $promotion->services->take(2); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <span class="badge badge-info"><?php echo e($service->name); ?></span>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php if($servicesCount > 2): ?>
                                                    <span class="text-muted">+<?php echo e($servicesCount - 2); ?> dịch vụ</span>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                            
                                            <?php if($combosCount > 0): ?>
                                                <?php $__currentLoopData = $promotion->combos->take(2); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $combo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <span class="badge badge-warning">
                                                        <i class="fas fa-layer-group"></i> <?php echo e($combo->name); ?>

                                                    </span>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php if($combosCount > 2): ?>
                                                    <span class="text-muted">+<?php echo e($combosCount - 2); ?> combo</span>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                            
                                            <?php if($variantsCount > 0): ?>
                                                <?php $__currentLoopData = $promotion->serviceVariants->take(2); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $variant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <span class="badge badge-success">
                                                        <i class="fas fa-tags"></i> <?php echo e($variant->name); ?>

                                                    </span>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php if($variantsCount > 2): ?>
                                                    <span class="text-muted">+<?php echo e($variantsCount - 2); ?> biến thể</span>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                            
                                            <?php
                                                $displayedCount = min(2, $servicesCount) + min(2, $combosCount) + min(2, $variantsCount);
                                                $remaining = $totalItems - $displayedCount;
                                            ?>
                                            <?php if($remaining > 0): ?>
                                                <span class="text-muted">+<?php echo e($remaining); ?> mục khác</span>
                                            <?php endif; ?>
                                        </div>
                                    <?php else: ?>
                                        <span class="text-muted">Tất cả dịch vụ</span>
                                    <?php endif; ?>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php echo e(optional($promotion->start_date)->format('d/m/Y')); ?> -
                                <?php echo e(optional($promotion->end_date)->format('d/m/Y') ?? 'Không giới hạn'); ?>

                            </td>
                            <td>
                                <?php
                                    $statusLabels = $statuses ?? [
                                        'inactive' => 'Ngừng áp dụng',
                                        'active' => 'Đang chạy',
                                        'scheduled' => 'Chờ áp dụng',
                                        'expired' => 'Đã kết thúc',
                                    ];
                                    $statusLabel = $statusLabels[$promotion->status] ?? ucfirst($promotion->status);
                                    $badgeClass = match($promotion->status) {
                                        'active' => 'success',
                                        'inactive' => 'secondary',
                                        'scheduled' => 'info',
                                        'expired' => 'warning',
                                        default => 'secondary'
                                    };
                                ?>
                                <span class="badge badge-<?php echo e($badgeClass); ?>">
                                    <?php echo e($statusLabel); ?>

                                </span>
                            </td>
                            <td>
                                <?php if(isset($isTrash) && $isTrash): ?>
                                    <a href="<?php echo e(route('admin.promotions.show', $promotion->id)); ?>" class="btn btn-sm btn-info" title="Xem chi tiết">
                                        <i class="fas fa-eye"></i> Xem
                                    </a>
                                    <form action="<?php echo e(route('admin.promotions.restore', $promotion->id)); ?>" method="POST" class="d-inline" onsubmit="return confirm('Bạn chắc chắn muốn khôi phục khuyến mãi này?');">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('PUT'); ?>
                                        <button type="submit" class="btn btn-sm btn-success" title="Khôi phục">
                                            <i class="fas fa-undo"></i> Khôi phục
                                        </button>
                                    </form>
                                    <form action="<?php echo e(route('admin.promotions.force-delete', $promotion->id)); ?>" method="POST" class="d-inline force-delete-form" data-id="<?php echo e($promotion->id); ?>">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="btn btn-sm btn-danger" title="Xóa vĩnh viễn">
                                            <i class="fas fa-trash-alt"></i> Xóa vĩnh viễn
                                        </button>
                                    </form>
                                <?php else: ?>
                                    <a href="<?php echo e(route('admin.promotions.show', $promotion->id)); ?>" class="btn btn-sm btn-info" title="Xem chi tiết">
                                        <i class="fas fa-eye"></i> Xem
                                    </a>
                                    <a href="<?php echo e(route('admin.promotions.edit', $promotion->id)); ?>" class="btn btn-sm btn-primary" title="Chỉnh sửa">
                                        <i class="fas fa-edit"></i> Sửa
                                    </a>
                                    <form action="<?php echo e(route('admin.promotions.destroy', $promotion->id)); ?>" method="POST" class="d-inline" onsubmit="return confirm('Bạn chắc chắn muốn xóa khuyến mãi này?');">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="btn btn-sm btn-danger" title="Xóa">
                                            <i class="fas fa-trash"></i> Xóa
                                        </button>
                                    </form>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="7" class="text-center">
                                <?php if(isset($isTrash) && $isTrash): ?>
                                    Thùng rác trống
                                <?php else: ?>
                                    Chưa có khuyến mãi nào
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    $(function () {
        $('#promotionsTable').DataTable({
            language: {
                url: "//cdn.datatables.net/plug-ins/1.10.24/i18n/Vietnamese.json"
            }
        });

        // Xử lý xóa vĩnh viễn
        const forceDeleteForms = document.querySelectorAll('.force-delete-form');
        forceDeleteForms.forEach(form => {
            form.addEventListener('submit', function(e) {
                e.preventDefault();
                const promotionId = this.getAttribute('data-id');
                if (confirm('Bạn có chắc chắn muốn xóa vĩnh viễn khuyến mãi này? Hành động này không thể hoàn tác!')) {
                    this.submit();
                }
            });
        });
    });
</script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\PolyHair\resources\views/admin/promotions/index.blade.php ENDPATH**/ ?>