<?php $__env->startSection('title', 'Quản lý hóa đơn'); ?>

<?php $__env->startSection('content'); ?>
<!-- Page Heading -->
<div class="d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h3 mb-0 text-gray-800">Quản lý hóa đơn</h1>
    <a href="<?php echo e(route('admin.payments.export')); ?>" class="btn btn-success">
        <i class="fas fa-file-excel"></i> Xuất Excel
    </a>
</div>

<!-- Filter -->
<div class="card shadow mb-4">
    <div class="card-header py-3">
        <h6 class="m-0 font-weight-bold text-primary">Tìm kiếm và lọc hóa đơn</h6>
    </div>
    <div class="card-body">
        <form method="GET" action="<?php echo e(route('admin.payments.index')); ?>">
            <div class="row">
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="invoice_code">Mã hóa đơn</label>
                        <input type="text" name="invoice_code" id="invoice_code" class="form-control" 
                               value="<?php echo e($filters['invoice_code'] ?? ''); ?>" placeholder="Nhập mã hóa đơn">
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="customer_name">Tên khách hàng</label>
                        <input type="text" name="customer_name" id="customer_name" class="form-control" 
                               value="<?php echo e($filters['customer_name'] ?? ''); ?>" placeholder="Nhập tên khách hàng">
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="date_from">Từ ngày</label>
                        <input type="date" name="date_from" id="date_from" class="form-control" 
                               value="<?php echo e($filters['date_from'] ?? ''); ?>">
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="date_to">Đến ngày</label>
                        <input type="date" name="date_to" id="date_to" class="form-control" 
                               value="<?php echo e($filters['date_to'] ?? ''); ?>">
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="status">Trạng thái</label>
                        <select name="status" id="status" class="form-control">
                            <option value="">-- Tất cả --</option>
                            <option value="pending" <?php echo e(($filters['status'] ?? '') == 'pending' ? 'selected' : ''); ?>>Chờ xử lý</option>
                            <option value="completed" <?php echo e(($filters['status'] ?? '') == 'completed' ? 'selected' : ''); ?>>Thành công</option>
                            <option value="failed" <?php echo e(($filters['status'] ?? '') == 'failed' ? 'selected' : ''); ?>>Thất bại</option>
                            <option value="refunded" <?php echo e(($filters['status'] ?? '') == 'refunded' ? 'selected' : ''); ?>>Hoàn tiền</option>
                        </select>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="type">Loại</label>
                        <select name="type" id="type" class="form-control">
                            <option value="">-- Tất cả --</option>
                            <option value="appointment" <?php echo e(($filters['type'] ?? '') == 'appointment' ? 'selected' : ''); ?>>Dịch vụ</option>
                            <option value="order" <?php echo e(($filters['type'] ?? '') == 'order' ? 'selected' : ''); ?>>Đơn hàng</option>
                        </select>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group" style="margin-top: 32px;">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-search"></i> Tìm kiếm
                        </button>
                        <a href="<?php echo e(route('admin.payments.index')); ?>" class="btn btn-secondary">
                            <i class="fas fa-redo"></i> Làm mới
                        </a>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- DataTales Example -->
<div class="card shadow mb-4">
    <div class="card-header py-3 d-flex justify-content-between align-items-center">
        <h6 class="m-0 font-weight-bold text-primary">Danh sách hóa đơn</h6>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-bordered" width="100%" cellspacing="0">
                <thead>
                    <tr>
                        <th>Mã hóa đơn</th>
                        <th>Khách hàng</th>
                        <th>Loại</th>
                        <th>Trạng thái</th>
                        <th>Tổng tiền</th>
                        <th>Ngày tạo</th>
                        <th>Người tạo</th>
                        <th>Hành động</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($payment->invoice_code ?? 'N/A'); ?></td>
                        <td><?php echo e($payment->user->name ?? 'Khách vãng lai'); ?></td>
                        <td>
                            <?php if($payment->appointment_id): ?>
                                <span class="badge badge-info">Dịch vụ</span>
                            <?php elseif($payment->order_id): ?>
                                <span class="badge badge-success">Đơn hàng</span>
                            <?php else: ?>
                                <span class="badge badge-secondary">Khác</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php
                                $status = $payment->status ?? 'pending';
                                $badgeClass = 'secondary';
                                $statusText = 'Chờ xử lý';
                                
                                if ($status == 'completed') {
                                    $badgeClass = 'success';
                                    $statusText = 'Thành công';
                                } elseif ($status == 'failed') {
                                    $badgeClass = 'danger';
                                    $statusText = 'Thất bại';
                                } elseif ($status == 'refunded') {
                                    $badgeClass = 'warning';
                                    $statusText = 'Hoàn tiền';
                                }
                            ?>
                            <span class="badge badge-<?php echo e($badgeClass); ?>"><?php echo e($statusText); ?></span>
                        </td>
                        <td><?php echo e(number_format($payment->total)); ?> VNĐ</td>
                        <td><?php echo e($payment->created_at ? $payment->created_at->format('d/m/Y H:i') : 'N/A'); ?></td>
                        <td><?php echo e($payment->created_by); ?></td>
                        <td>
                            <a href="<?php echo e(route('admin.payments.show', $payment->id)); ?>" class="btn btn-info btn-sm" title="Xem chi tiết">
                                <i class="fas fa-eye"></i> Xem
                            </a>
                            <form action="<?php echo e(route('admin.payments.destroy', $payment->id)); ?>" method="POST" class="d-inline" onsubmit="return confirm('Bạn có chắc muốn xóa hóa đơn này? Hành động này không thể hoàn tác!');">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="btn btn-danger btn-sm" title="Xóa hóa đơn">
                                    <i class="fas fa-trash"></i> Xóa
                                </button>
                            </form>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
            
            <?php echo e($payments->appends(request()->query())->links('admin.partials.pagination')); ?>

        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
    /* Custom Pagination Styles */
    .pagination {
        border: 1px solid #e0e0e0;
        border-radius: 4px;
        padding: 0;
        background: #fff;
    }
    
    .pagination .page-item {
        margin: 0;
    }
    
    .pagination .page-item:first-child .page-link {
        border-top-left-radius: 4px;
        border-bottom-left-radius: 4px;
    }
    
    .pagination .page-item:last-child .page-link {
        border-top-right-radius: 4px;
        border-bottom-right-radius: 4px;
    }
    
    .pagination .page-link {
        color: #5a5c69;
        background-color: #fff;
        border: none;
        padding: 8px 16px;
        margin: 0;
        border-right: 1px solid #e0e0e0;
    }
    
    .pagination .page-item:last-child .page-link {
        border-right: none;
    }
    
    .pagination .page-link:hover {
        background-color: #f8f9fa;
        color: #5a5c69;
    }
    
    .pagination .page-item.active .page-link {
        background-color: #4e73df;
        color: #fff;
        border-color: #4e73df;
    }
    
    .pagination .page-item.disabled .page-link {
        color: #6c757d;
        background-color: #fff;
        cursor: not-allowed;
        opacity: 0.6;
    }
    
    .pagination .page-item.disabled .page-link:hover {
        background-color: #fff;
    }
</style>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\laragon\www\polyhair\resources\views/admin/payments/index.blade.php ENDPATH**/ ?>