<?php $__env->startSection('title', 'Chi tiết khuyến mãi'); ?>

<?php $__env->startSection('content'); ?>
<div class="d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h3 mb-0 text-gray-800">Chi tiết khuyến mãi: <?php echo e($promotion->code); ?></h1>
    <div>
        <a href="<?php echo e(route('admin.promotions.edit', $promotion->id)); ?>" class="btn btn-primary btn-sm">
            <i class="fas fa-edit"></i> Chỉnh sửa
        </a>
        <a href="<?php echo e(route('admin.promotions.index')); ?>" class="btn btn-secondary btn-sm">
            <i class="fas fa-arrow-left"></i> Quay lại danh sách
        </a>
    </div>
</div>

<div class="row">
    <div class="col-lg-6">
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-primary">Thông tin chung</h6>
            </div>
            <div class="card-body">
                <dl class="row mb-0">
                    <dt class="col-sm-4">Mã khuyến mãi</dt>
                    <dd class="col-sm-8"><?php echo e($promotion->code); ?></dd>

                    <dt class="col-sm-4">Tên khuyến mãi</dt>
                    <dd class="col-sm-8"><?php echo e($promotion->name); ?></dd>

                    <?php if($promotion->description): ?>
                        <dt class="col-sm-4">Mô tả</dt>
                        <dd class="col-sm-8"><?php echo e($promotion->description); ?></dd>
                    <?php endif; ?>

                    <dt class="col-sm-4">Trạng thái</dt>
                    <dd class="col-sm-8">
                        <?php
                            $statusLabels = $statuses ?? [
                                'inactive' => 'Ngừng áp dụng',
                                'active' => 'Đang chạy',
                                'scheduled' => 'Chờ áp dụng',
                                'expired' => 'Đã kết thúc',
                            ];
                            $statusLabel = $statusLabels[$promotion->status] ?? ucfirst($promotion->status);
                            $badgeClass = match($promotion->status) {
                                'active' => 'success',
                                'inactive' => 'secondary',
                                'scheduled' => 'info',
                                'expired' => 'warning',
                                default => 'secondary'
                            };
                        ?>
                        <span class="badge badge-<?php echo e($badgeClass); ?>"><?php echo e($statusLabel); ?></span>
                    </dd>

                    <dt class="col-sm-4">Thời gian áp dụng</dt>
                    <dd class="col-sm-8">
                        <?php echo e($promotion->start_date ? $promotion->start_date->format('d/m/Y') : 'N/A'); ?>

                        -
                        <?php echo e($promotion->end_date ? $promotion->end_date->format('d/m/Y') : 'Không giới hạn'); ?>

                    </dd>

                    <dt class="col-sm-4">Ngày tạo</dt>
                    <dd class="col-sm-8">
                        <?php echo e($promotion->created_at ? $promotion->created_at->format('d/m/Y H:i') : 'N/A'); ?>

                    </dd>

                    <dt class="col-sm-4">Ngày cập nhật</dt>
                    <dd class="col-sm-8">
                        <?php echo e($promotion->updated_at ? $promotion->updated_at->format('d/m/Y H:i') : 'N/A'); ?>

                    </dd>
                </dl>
            </div>
        </div>
    </div>

    <div class="col-lg-6">
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-primary">Quy tắc giảm giá</h6>
            </div>
            <div class="card-body">
                <dl class="row mb-0">
                    <dt class="col-sm-4">Loại giảm giá</dt>
                    <dd class="col-sm-8">
                        <?php if($promotion->discount_type === 'percent'): ?>
                            Giảm theo %
                        <?php else: ?>
                            Giảm theo số tiền
                        <?php endif; ?>
                    </dd>

                    <dt class="col-sm-4">Giá trị giảm</dt>
                    <dd class="col-sm-8">
                        <?php if($promotion->discount_type === 'percent'): ?>
                            <?php echo e($promotion->discount_percent !== null ? $promotion->discount_percent . '%' : '-'); ?>

                            <?php if($promotion->max_discount_amount): ?>
                                <span class="text-muted">
                                    (tối đa <?php echo e(number_format($promotion->max_discount_amount, 0, ',', '.')); ?> đ)
                                </span>
                            <?php endif; ?>
                        <?php else: ?>
                            <?php echo e($promotion->discount_amount !== null ? number_format($promotion->discount_amount, 0, ',', '.') . ' đ' : '-'); ?>

                        <?php endif; ?>
                    </dd>

                    <dt class="col-sm-4">Áp dụng theo</dt>
                    <dd class="col-sm-8">
                        <?php if($promotion->apply_scope === 'order'): ?>
                            <span class="badge badge-primary">Theo hóa đơn</span>
                        <?php elseif($promotion->apply_scope === 'customer_tier'): ?>
                            <span class="badge badge-warning">Theo hạng khách hàng</span>
                        <?php else: ?>
                            <span class="badge badge-info">Theo dịch vụ</span>
                        <?php endif; ?>
                    </dd>

                    <?php if($promotion->apply_scope === 'order'): ?>
                        <dt class="col-sm-4">Hóa đơn tối thiểu</dt>
                        <dd class="col-sm-8">
                            <?php if($promotion->min_order_amount): ?>
                                <?php echo e(number_format($promotion->min_order_amount, 0, ',', '.')); ?> đ
                            <?php else: ?>
                                Không yêu cầu
                            <?php endif; ?>
                        </dd>
                    <?php endif; ?>

                    <?php if($promotion->apply_scope === 'customer_tier'): ?>
                        <dt class="col-sm-4">Hạng khách hàng</dt>
                        <dd class="col-sm-8">
                            Áp dụng cho khách từ hạng 
                            <strong><?php echo e($promotion->min_customer_tier ?? 'Khách thường'); ?></strong> trở lên
                        </dd>
                    <?php endif; ?>

                    <dt class="col-sm-4">Số lần / tài khoản</dt>
                    <dd class="col-sm-8">
                        <?php if($promotion->per_user_limit): ?>
                            Tối đa <?php echo e($promotion->per_user_limit); ?> lần
                        <?php else: ?>
                            Không giới hạn
                        <?php endif; ?>
                    </dd>

                    <dt class="col-sm-4">Tổng lượt dùng</dt>
                    <dd class="col-sm-8">
                        <?php if($promotion->usage_limit): ?>
                            Tối đa <?php echo e($promotion->usage_limit); ?> lượt cho toàn hệ thống
                        <?php else: ?>
                            Không giới hạn
                        <?php endif; ?>
                    </dd>
                </dl>
            </div>
        </div>
    </div>
</div>

<?php if($promotion->apply_scope === 'service'): ?>
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Dịch vụ áp dụng</h6>
        </div>
        <div class="card-body">
            <?php
                $servicesCount = $promotion->services->count();
                $combosCount = $promotion->combos->count();
                $variantsCount = $promotion->serviceVariants->count();
                $totalItems = $servicesCount + $combosCount + $variantsCount;
            ?>

            <?php if($totalItems === 0): ?>
                <div class="alert alert-info mb-0">
                    <i class="fas fa-info-circle"></i>
                    Khuyến mãi này hiện đang áp dụng cho <strong>tất cả dịch vụ</strong>.
                </div>
            <?php else: ?>
                <div class="row">
                    <div class="col-md-4">
                        <h6 class="font-weight-bold">Dịch vụ</h6>
                        <?php $__empty_1 = true; $__currentLoopData = $promotion->services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <div class="mb-2">
                                <span class="badge badge-info"><?php echo e($service->name); ?></span>
                                <?php if($service->category): ?>
                                    <small class="text-muted">(<?php echo e($service->category->name); ?>)</small>
                                <?php endif; ?>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <p class="text-muted mb-0">Không có dịch vụ cụ thể.</p>
                        <?php endif; ?>
                    </div>
                    <div class="col-md-4">
                        <h6 class="font-weight-bold">Combo</h6>
                        <?php $__empty_1 = true; $__currentLoopData = $promotion->combos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $combo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <div class="mb-2">
                                <span class="badge badge-warning">
                                    <i class="fas fa-layer-group"></i> <?php echo e($combo->name); ?>

                                </span>
                                <?php if($combo->price): ?>
                                    <small class="text-muted">
                                        - <?php echo e(number_format($combo->price, 0, ',', '.')); ?> đ
                                    </small>
                                <?php endif; ?>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <p class="text-muted mb-0">Không có combo nào.</p>
                        <?php endif; ?>
                    </div>
                    <div class="col-md-4">
                        <h6 class="font-weight-bold">Dịch vụ biến thể</h6>
                        <?php $__empty_1 = true; $__currentLoopData = $promotion->serviceVariants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $variant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <div class="mb-2">
                                <span class="badge badge-success">
                                    <i class="fas fa-tags"></i> <?php echo e($variant->name); ?>

                                </span>
                                <?php if($variant->service): ?>
                                    <small class="text-muted">(<?php echo e($variant->service->name); ?>)</small>
                                <?php endif; ?>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <p class="text-muted mb-0">Không có dịch vụ biến thể.</p>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
<?php endif; ?>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\laragon\www\polyhair\resources\views/admin/promotions/show.blade.php ENDPATH**/ ?>