<?php if($paginator->hasPages()): ?>
    <div class="d-flex justify-content-between align-items-center mt-3">
        
        <div class="text-muted">
            Đang xem <?php echo e($paginator->firstItem()); ?> đến <?php echo e($paginator->lastItem()); ?> trong tổng số <?php echo e($paginator->total()); ?> mục
        </div>

        
        <nav>
            <ul class="pagination mb-0">
                
                <?php if($paginator->onFirstPage()): ?>
                    <li class="page-item disabled">
                        <span class="page-link">Trước</span>
                    </li>
                <?php else: ?>
                    <li class="page-item">
                        <a class="page-link" href="<?php echo e($paginator->previousPageUrl()); ?>" rel="prev">Trước</a>
                    </li>
                <?php endif; ?>

                
                <?php
                    // Sử dụng getUrlRange để lấy danh sách các trang
                    $currentPage = $paginator->currentPage();
                    $lastPage = $paginator->lastPage();
                    
                    // Chỉ hiển thị tối đa 5 trang xung quanh trang hiện tại
                    $start = max(1, $currentPage - 2);
                    $end = min($lastPage, $currentPage + 2);
                    
                    // Điều chỉnh nếu gần đầu hoặc cuối
                    if ($end - $start < 4) {
                        if ($start == 1) {
                            $end = min($lastPage, $start + 4);
                        } else {
                            $start = max(1, $end - 4);
                        }
                    }
                    
                    $pageUrls = $paginator->getUrlRange($start, $end);
                ?>
                
                <?php $__currentLoopData = $pageUrls; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page => $url): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if($page == $paginator->currentPage()): ?>
                        <li class="page-item active" aria-current="page">
                            <span class="page-link"><?php echo e($page); ?></span>
                        </li>
                    <?php else: ?>
                        <li class="page-item">
                            <a class="page-link" href="<?php echo e($url); ?>"><?php echo e($page); ?></a>
                        </li>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                
                <?php if($paginator->hasMorePages()): ?>
                    <li class="page-item">
                        <a class="page-link" href="<?php echo e($paginator->nextPageUrl()); ?>" rel="next">Tiếp</a>
                    </li>
                <?php else: ?>
                    <li class="page-item disabled">
                        <span class="page-link">Tiếp</span>
                    </li>
                <?php endif; ?>
            </ul>
        </nav>
    </div>
<?php endif; ?>

<?php /**PATH E:\laragon\www\polyhair\resources\views/admin/partials/pagination.blade.php ENDPATH**/ ?>