<?php $__env->startSection('title', 'Chi tiết đơn đặt'); ?>

<?php $__env->startSection('content'); ?>
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Chi tiết đơn đặt <?php echo e($appointment->booking_code ?? '#' . $appointment->id); ?></h1>
        <a href="<?php echo e(route('employee.appointments.index')); ?>" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> Quay lại
        </a>
    </div>

    <!-- Appointment Info -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Thông tin đơn đặt</h6>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label class="font-weight-bold">Mã đơn đặt:</label>
                        <p class="form-control-plaintext"><?php echo e($appointment->booking_code ?? '#' . $appointment->id); ?></p>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label class="font-weight-bold">Trạng thái:</label>
                        <p>
                            <span class="badge badge-<?php echo e($appointment->status == 'Hoàn thành' ? 'success' :
        ($appointment->status == 'Đã hủy' ? 'danger' :
            ($appointment->status == 'Đã xác nhận' || $appointment->status == 'Đang thực hiện' ? 'info' : 'warning'))); ?> badge-lg">
                                <?php echo e($appointment->status); ?>

                            </span>
                        </p>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label class="font-weight-bold">Tên khách hàng:</label>
                        <p class="form-control-plaintext"><?php echo e($appointment->user->name ?? $appointment->guest_name ?? 'N/A'); ?></p>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label class="font-weight-bold">Số điện thoại:</label>
                        <p class="form-control-plaintext"><?php echo e($appointment->user->phone ?? $appointment->guest_phone ?? 'N/A'); ?></p>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label class="font-weight-bold">Ngày và giờ:</label>
                        <p class="form-control-plaintext">
                            <?php if($appointment->start_at): ?>
                                <?php echo e($appointment->start_at->format('d/m/Y H:i')); ?>

                                <?php if($appointment->end_at): ?>
                                    - <?php echo e($appointment->end_at->format('H:i')); ?>

                                <?php endif; ?>
                            <?php else: ?>
                                <span class="text-muted">Chưa có</span>
                            <?php endif; ?>
                        </p>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label class="font-weight-bold">Nhân viên phụ trách:</label>
                        <p class="form-control-plaintext"><?php echo e($appointment->employee->user->name ?? 'Chưa phân công'); ?></p>
                    </div>
                </div>
            </div>

            <?php if($appointment->promotionUsages && $appointment->promotionUsages->count() > 0): ?>
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="font-weight-bold">Khuyến mãi áp dụng:</label>
                            <ul class="list-unstyled mb-0">
                                <?php $__currentLoopData = $appointment->promotionUsages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $usage): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($usage->promotion): ?>
                                        <li>
                                            <span class="badge badge-info">
                                                <?php echo e($usage->promotion->code); ?>

                                            </span>
                                            - <?php echo e($usage->promotion->name); ?>

                                            <?php if($usage->promotion->discount_percent): ?>
                                                (<?php echo e($usage->promotion->discount_percent); ?>%)
                                            <?php elseif($usage->promotion->discount_amount): ?>
                                                (<?php echo e(number_format($usage->promotion->discount_amount, 0, ',', '.')); ?>đ)
                                            <?php endif; ?>
                                        </li>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <?php if($appointment->note): ?>
                <div class="form-group">
                    <label class="font-weight-bold">Ghi chú:</label>
                    <p class="form-control-plaintext"><?php echo e($appointment->note); ?></p>
                </div>
            <?php endif; ?>

            <?php if($appointment->cancellation_reason): ?>
                <div class="form-group">
                    <label class="font-weight-bold text-danger">Lý do hủy:</label>
                    <p class="form-control-plaintext text-danger"><?php echo e($appointment->cancellation_reason); ?></p>
                </div>
            <?php endif; ?>
        </div>
    </div>

<!-- Appointment Details -->
<div class="card shadow mb-4">
    <div class="card-header py-3">
        <h6 class="m-0 font-weight-bold text-primary">Chi tiết dịch vụ</h6>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>Dịch vụ</th>
                        <th>Biến thể</th>
                        <th>Giá</th>
                        <th>Thời lượng (phút)</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $appointment->appointmentDetails; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td>
                                <?php if($detail->serviceVariant && $detail->serviceVariant->service): ?>
                                    <?php echo e($detail->serviceVariant->service->name); ?>

                                <?php elseif($detail->combo_id && $detail->combo): ?>
                                    <?php echo e($detail->combo->name); ?>

                                <?php elseif($detail->notes): ?>
                                    <?php echo e($detail->notes); ?>

                                <?php else: ?>
                                    N/A
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($detail->serviceVariant && $detail->serviceVariant->name): ?>
                                    <?php echo e($detail->serviceVariant->name); ?>

                                <?php elseif($detail->combo_id && $detail->combo): ?>
                                    <span class="badge badge-secondary">Combo</span>
                                <?php elseif($detail->notes): ?>
                                    <span class="badge badge-secondary">Dịch vụ đơn</span>
                                <?php else: ?>
                                    N/A
                                <?php endif; ?>
                            </td>
                            <td><?php echo e(number_format($detail->price_snapshot ?? 0, 0, ',', '.')); ?> đ</td>
                            <td><?php echo e($detail->duration ?? 'N/A'); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="4" class="text-center">Chưa có dịch vụ nào</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

    <!-- Action Buttons -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Thao tác</h6>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-12">
                    <?php if($appointment->status == 'Hoàn thành' || $appointment->status == 'Chưa thanh toán'): ?>
                        <a href="<?php echo e(route('employee.appointments.checkout', ['appointment_id' => $appointment->id])); ?>" class="btn btn-primary btn-lg">
                            <i class="fas fa-money-bill-wave"></i> Thanh toán
                        </a>
                    <?php endif; ?>

                    <?php if($appointment->status == 'Chờ xác nhận' || $appointment->status == 'Chờ xử lý'): ?>
                        <form action="<?php echo e(route('employee.appointments.confirm', $appointment->id)); ?>" method="POST"
                            class="d-inline">
                            <?php echo csrf_field(); ?>
                            <button type="submit" class="btn btn-success btn-lg">
                                <i class="fas fa-check"></i> Xác nhận đơn
                            </button>
                        </form>
                    <?php endif; ?>

                    <?php if($appointment->status == 'Đã xác nhận'): ?>
                        <form action="<?php echo e(route('employee.appointments.start', $appointment->id)); ?>" method="POST"
                            class="d-inline">
                            <?php echo csrf_field(); ?>
                            <button type="submit" class="btn btn-info btn-lg">
                                <i class="fas fa-play"></i> Bắt đầu thực hiện
                            </button>
                        </form>
                    <?php endif; ?>

                    <?php if($appointment->status == 'Đang thực hiện'): ?>
                        <form action="<?php echo e(route('employee.appointments.complete', $appointment->id)); ?>" method="POST"
                            class="d-inline">
                            <?php echo csrf_field(); ?>
                            <button type="submit" class="btn btn-success btn-lg">
                                <i class="fas fa-check-circle"></i> Hoàn thành
                            </button>
                        </form>
                    <?php endif; ?>

                    <?php if($appointment->status == 'Chờ xác nhận' || $appointment->status == 'Chờ xử lý'): ?>
                        <button type="button" class="btn btn-danger btn-lg" data-toggle="modal" data-target="#cancelModal">
                            <i class="fas fa-times"></i> Hủy đơn
                        </button>
                        <form action="<?php echo e(route('employee.appointments.destroy', $appointment->id)); ?>" method="POST"
                            class="d-inline"
                            onsubmit="return confirm('Bạn có chắc chắn muốn xóa đơn đặt này? Hành động này không thể hoàn tác.');">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="btn btn-danger btn-lg">
                                <i class="fas fa-trash"></i> Xóa đơn
                            </button>
                        </form>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Cancel Modal -->
    <div class="modal fade" id="cancelModal" tabindex="-1" role="dialog" aria-labelledby="cancelModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <form action="<?php echo e(route('employee.appointments.cancel', $appointment->id)); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="modal-header">
                        <h5 class="modal-title" id="cancelModalLabel">Hủy đơn đặt</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="cancellation_reason">Lý do hủy <span class="text-danger">*</span></label>
                            <textarea name="cancellation_reason" id="cancellation_reason"
                                class="form-control <?php $__errorArgs = ['cancellation_reason'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" rows="4" required
                                placeholder="Nhập lý do hủy đơn..."><?php echo e(old('cancellation_reason')); ?></textarea>
                            <?php $__errorArgs = ['cancellation_reason'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Đóng</button>
                        <button type="submit" class="btn btn-danger">Xác nhận hủy</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
    <style>
        .badge-lg {
            font-size: 1rem;
            padding: 0.5rem 1rem;
        }
    </style>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\laragon\www\polyhair\resources\views/admin/employee-appointments/show.blade.php ENDPATH**/ ?>