<?php $__env->startSection('title', 'Sửa lịch hẹn'); ?>

<?php $__env->startSection('content'); ?>
<!-- Page Heading -->
<div class="d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h3 mb-0 text-gray-800">Sửa lịch hẹn <?php echo e($appointment->booking_code ?? '#' . $appointment->id); ?></h1>
    <a href="<?php echo e(route('admin.appointments.index')); ?>" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> Quay lại
    </a>
</div>

<!-- Form -->
<div class="card shadow mb-4">
    <div class="card-header py-3">
        <h6 class="m-0 font-weight-bold text-primary">Thông tin lịch hẹn</h6>
    </div>
    <div class="card-body">
        <form id="appointment-edit-form" action="<?php echo e(route('admin.appointments.update', $appointment->id)); ?>" method="POST" class="needs-validation" novalidate>
            <?php echo csrf_field(); ?>
            <input type="hidden" name="_method" value="PUT" id="form-method-put">
            
            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="name">Tên khách hàng <span class="text-danger">*</span></label>
                        <input type="text" name="name" id="name" value="<?php echo e(old('name', $appointment->user->name ?? $appointment->guest_name ?? '')); ?>" 
                               class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                               placeholder="Nhập tên khách hàng" required>
                        <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php else: ?>
                            <div class="invalid-feedback">Vui lòng nhập tên khách hàng</div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="phone">Số điện thoại <span class="text-danger">*</span></label>
                        <input type="text" name="phone" id="phone" value="<?php echo e(old('phone', $appointment->user->phone ?? '')); ?>" 
                               class="form-control <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                               placeholder="Nhập số điện thoại" required>
                        <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php else: ?>
                            <div class="invalid-feedback">Vui lòng nhập số điện thoại</div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="email">Email</label>
                        <input type="email" name="email" id="email" value="<?php echo e(old('email', $appointment->user->email ?? '')); ?>" 
                               class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                               placeholder="Nhập email">
                        <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="employee_id">Nhân viên</label>
                        <select name="employee_id" id="employee_id" class="form-control <?php $__errorArgs = ['employee_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                            <option value="">-- Chọn nhân viên --</option>
                            <?php $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($employee->id); ?>" <?php echo e(old('employee_id', $appointment->employee_id) == $employee->id ? 'selected' : ''); ?>>
                                    <?php echo e($employee->user->name ?? 'N/A'); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php $__errorArgs = ['employee_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
            </div>

            <!-- Dịch vụ hiện có -->
            <div class="row">
                <div class="col-md-12">
                    <div class="form-group">
                        <label>Dịch vụ hiện có</label>
                        <div class="table-responsive">
                            <table class="table table-bordered">
                                <thead>
                                    <tr>
                                        <th>Dịch vụ</th>
                                        <th>Giá</th>
                                        <th>Thời lượng (phút)</th>
                                        <th>Thao tác</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__empty_1 = true; $__currentLoopData = $appointment->appointmentDetails; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr>
                                            <td>
                                                <?php if($detail->combo_id): ?>
                                                    <?php echo e($detail->combo->name ?? ($detail->notes ?? 'Combo')); ?>

                                                <?php elseif($detail->serviceVariant): ?>
                                                    <?php echo e($detail->serviceVariant->name ?? ($detail->serviceVariant->service->name ?? 'N/A')); ?>

                                                <?php else: ?>
                                                    <?php echo e($detail->notes ?? 'Dịch vụ đơn'); ?>

                                                <?php endif; ?>
                                            </td>
                                            <td><?php echo e(number_format($detail->price_snapshot ?? 0, 0, ',', '.')); ?> đ</td>
                                            <td><?php echo e($detail->duration ?? 0); ?></td>
                                            <td>
                                                <form action="<?php echo e(route('admin.appointments.remove-service', [$appointment->id, $detail->id])); ?>" method="POST" class="d-inline" onsubmit="return confirm('Bạn có chắc muốn xóa dịch vụ này?');">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button type="submit" class="btn btn-sm btn-danger">
                                                        <i class="fas fa-trash"></i> Xóa
                                                    </button>
                                                </form>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr>
                                            <td colspan="4" class="text-center">Chưa có dịch vụ nào</td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Thêm dịch vụ mới -->
            <div class="row">
                <div class="col-md-12">
                    <div class="form-group">
                        <label>Thêm dịch vụ mới</label>
                        <div class="border rounded p-3" style="max-height: 400px; overflow-y: auto;">
                            <!-- Dịch vụ đơn -->
                            <?php if($singleServices->count() > 0): ?>
                                <div class="mb-3">
                                    <h6 class="text-primary">Dịch vụ đơn</h6>
                                    <div class="row">
                                        <?php $__currentLoopData = $singleServices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="col-md-4 mb-2">
                                                <div class="form-check">
                                                    <input class="form-check-input service-checkbox" type="checkbox" 
                                                           name="new_services[]" 
                                                           value="single_<?php echo e($service->id); ?>" 
                                                           id="service_single_<?php echo e($service->id); ?>"
                                                           data-type="single"
                                                           data-id="<?php echo e($service->id); ?>"
                                                           data-price="<?php echo e($service->base_price ?? 0); ?>"
                                                           data-duration="<?php echo e($service->base_duration ?? 0); ?>">
                                                    <label class="form-check-label" for="service_single_<?php echo e($service->id); ?>">
                                                        <?php echo e($service->name); ?> - <?php echo e(number_format($service->base_price ?? 0, 0, ',', '.')); ?> đ
                                                    </label>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            <?php endif; ?>
                            
                            <!-- Dịch vụ biến thể -->
                            <?php if($variantServices->count() > 0): ?>
                                <div class="mb-3">
                                    <h6 class="text-primary">Dịch vụ biến thể</h6>
                                    <?php $__currentLoopData = $variantServices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="mb-2">
                                            <strong><?php echo e($service->name); ?></strong>
                                            <div class="row ml-3">
                                                <?php $__currentLoopData = $service->serviceVariants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $variant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div class="col-md-4 mb-2">
                                                        <div class="form-check">
                                                            <input class="form-check-input service-checkbox" type="checkbox" 
                                                                   name="new_services[]" 
                                                                   value="variant_<?php echo e($variant->id); ?>" 
                                                                   id="service_variant_<?php echo e($variant->id); ?>"
                                                                   data-type="variant"
                                                                   data-id="<?php echo e($variant->id); ?>"
                                                                   data-service-id="<?php echo e($service->id); ?>"
                                                                   data-price="<?php echo e($variant->price); ?>"
                                                                   data-duration="<?php echo e($variant->duration); ?>">
                                                            <label class="form-check-label" for="service_variant_<?php echo e($variant->id); ?>">
                                                                <?php echo e($variant->name); ?> - <?php echo e(number_format($variant->price, 0, ',', '.')); ?> đ
                                                            </label>
                                                        </div>
                                                    </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            <?php endif; ?>
                            
                            <!-- Combo -->
                            <?php if($combos->count() > 0): ?>
                                <div class="mb-3">
                                    <h6 class="text-primary">Combo</h6>
                                    <div class="row">
                                        <?php $__currentLoopData = $combos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $combo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="col-md-4 mb-2">
                                                <div class="form-check">
                                                    <input class="form-check-input service-checkbox" type="checkbox" 
                                                           name="new_services[]" 
                                                           value="combo_<?php echo e($combo->id); ?>" 
                                                           id="service_combo_<?php echo e($combo->id); ?>"
                                                           data-type="combo"
                                                           data-id="<?php echo e($combo->id); ?>"
                                                           data-price="<?php echo e($combo->price); ?>"
                                                           data-duration="0">
                                                    <label class="form-check-label" for="service_combo_<?php echo e($combo->id); ?>">
                                                        <?php echo e($combo->name); ?> - <?php echo e(number_format($combo->price, 0, ',', '.')); ?> đ
                                                    </label>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                        <small class="text-muted">Chọn dịch vụ để thêm vào lịch hẹn (có thể chọn nhiều)</small>
                    </div>
                </div>
            </div>
            
            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="status">Trạng thái <span class="text-danger">*</span></label>
                        <select name="status" id="status" class="form-control <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                            <option value="Chờ xử lý" <?php echo e(old('status', $appointment->status) == 'Chờ xử lý' ? 'selected' : ''); ?>>Chờ xử lý</option>
                            <option value="Đã xác nhận" <?php echo e(old('status', $appointment->status) == 'Đã xác nhận' ? 'selected' : ''); ?>>Đã xác nhận</option>
                            <option value="Đang thực hiện" <?php echo e(old('status', $appointment->status) == 'Đang thực hiện' ? 'selected' : ''); ?>>Đang thực hiện</option>
                            <option value="Hoàn thành" <?php echo e(old('status', $appointment->status) == 'Hoàn thành' ? 'selected' : ''); ?>>Hoàn thành</option>
                            <option value="Đã hủy" <?php echo e(old('status', $appointment->status) == 'Đã hủy' ? 'selected' : ''); ?>>Đã hủy</option>
                        </select>
                        <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php else: ?>
                            <div class="invalid-feedback">Vui lòng chọn trạng thái</div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="appointment_date">Ngày đặt</label>
                        <input type="date" name="appointment_date" id="appointment_date" 
                               value="<?php echo e(old('appointment_date', $appointment->start_at ? $appointment->start_at->format('Y-m-d') : '')); ?>" 
                               class="form-control <?php $__errorArgs = ['appointment_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                               min="<?php echo e(date('Y-m-d')); ?>">
                        <?php $__errorArgs = ['appointment_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        <small class="form-text text-muted">Không được chọn ngày trong quá khứ</small>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="appointment_time">Giờ đặt</label>
                        <input type="time" name="appointment_time" id="appointment_time" 
                               value="<?php echo e(old('appointment_time', $appointment->start_at ? $appointment->start_at->format('H:i') : '')); ?>" 
                               class="form-control <?php $__errorArgs = ['appointment_time'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                        <?php $__errorArgs = ['appointment_time'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        <small class="form-text text-muted">Nếu chọn ngày hôm nay, giờ phải lớn hơn giờ hiện tại</small>
                    </div>
                </div>
            </div>

            <div class="form-group">
                <label for="note">Mô tả</label>
                <textarea name="note" id="note" rows="3" 
                          class="form-control <?php $__errorArgs = ['note'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                          placeholder="Nhập mô tả (nếu có)"><?php echo e(old('note', $appointment->note)); ?></textarea>
                <?php $__errorArgs = ['note'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div class="form-group">
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save"></i> Lưu
                </button>
                <a href="<?php echo e(route('admin.appointments.index')); ?>" class="btn btn-secondary">Hủy</a>
            </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    (function() {
        'use strict';
        window.addEventListener('load', function() {
            // Chỉ validate form chính (form edit appointment)
            var mainForm = document.getElementById('appointment-edit-form');
            if (mainForm) {
                mainForm.addEventListener('submit', function(event) {
                    // Đảm bảo method là PUT
                    var methodInput = document.getElementById('form-method-put');
                    if (methodInput) {
                        methodInput.value = 'PUT';
                    }
                    
                    // Kiểm tra xem có input _method nào khác không và xóa nếu không phải PUT
                    var allMethodInputs = mainForm.querySelectorAll('input[name="_method"]');
                    allMethodInputs.forEach(function(input) {
                        if (input.id !== 'form-method-put') {
                            input.remove();
                        } else {
                            input.value = 'PUT';
                        }
                    });
                    
                    if (mainForm.checkValidity() === false) {
                        event.preventDefault();
                        event.stopPropagation();
                    }
                    mainForm.classList.add('was-validated');
                }, false);
            }
            
            // Validate các form khác (form xóa dịch vụ)
            var otherForms = document.querySelectorAll('.needs-validation:not(#appointment-edit-form)');
            otherForms.forEach(function(form) {
                form.addEventListener('submit', function(event) {
                    if (form.checkValidity() === false) {
                        event.preventDefault();
                        event.stopPropagation();
                    }
                    form.classList.add('was-validated');
                }, false);
            });
        }, false);
    })();
    
    // Không cần lọc dịch vụ theo nhân viên - hiển thị tất cả dịch vụ
    
    // Validation: Không cho phép chọn ngày giờ trong quá khứ
    $(document).ready(function() {
        const appointmentDateInput = $('#appointment_date');
        const appointmentTimeInput = $('#appointment_time');
        const today = new Date();
        const todayStr = today.toISOString().split('T')[0]; // Format: YYYY-MM-DD
        
        // Set min date to today
        appointmentDateInput.attr('min', todayStr);
        
        // Validate date and time on change
        function validateDateTime() {
            const selectedDate = appointmentDateInput.val();
            const selectedTime = appointmentTimeInput.val();
            
            if (!selectedDate || !selectedTime) {
                return true; // Allow empty values
            }
            
            const selectedDateTime = new Date(selectedDate + ' ' + selectedTime);
            const now = new Date();
            
            // Check if selected datetime is in the past
            if (selectedDateTime < now) {
                alert('Không được chọn ngày giờ trong quá khứ! Vui lòng chọn ngày giờ từ bây giờ trở đi.');
                // Reset to current date/time
                appointmentDateInput.val(todayStr);
                const currentTime = now.toTimeString().slice(0, 5); // Format: HH:MM
                appointmentTimeInput.val(currentTime);
                return false;
            }
            
            return true;
        }
        
        // Validate when date changes
        appointmentDateInput.on('change', function() {
            const selectedDate = $(this).val();
            const today = new Date();
            const todayStr = today.toISOString().split('T')[0];
            
            // If selected date is today, set min time to current time
            if (selectedDate === todayStr) {
                const now = new Date();
                const currentTime = now.toTimeString().slice(0, 5);
                appointmentTimeInput.attr('min', currentTime);
            } else {
                // If future date, remove min time restriction
                appointmentTimeInput.removeAttr('min');
            }
            
            validateDateTime();
        });
        
        // Validate when time changes
        appointmentTimeInput.on('change', function() {
            validateDateTime();
        });
        
        // Validate on form submit
        $('#appointment-edit-form').on('submit', function(e) {
            if (!validateDateTime()) {
                e.preventDefault();
                return false;
            }
        });
    });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\laragon\www\polyhair\resources\views/admin/appointments/edit.blade.php ENDPATH**/ ?>