<?php $__env->startSection('title', 'Quản lý chuyên môn nhân viên'); ?>

<?php $__env->startSection('content'); ?>
<div class="d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h3 mb-0 text-gray-800">Quản lý chuyên môn nhân viên</h1>
    <a href="<?php echo e(route('admin.employees.index')); ?>" class="btn btn-secondary">
        <i class="fas fa-users"></i> Danh sách nhân viên
    </a>
</div>

<!-- Filter -->
<div class="card shadow mb-4">
    <div class="card-header py-3">
        <h6 class="m-0 font-weight-bold text-primary">Lọc nhân viên</h6>
    </div>
    <div class="card-body">
        <form method="GET" action="<?php echo e(route('admin.employee-skills.index')); ?>" class="form-row">
            <div class="form-group col-md-4">
                <label for="keyword">Tên nhân viên</label>
                <input type="text" name="keyword" id="keyword" class="form-control" placeholder="Nhập tên nhân viên"
                    value="<?php echo e($filters['keyword'] ?? ''); ?>">
            </div>
            <div class="form-group col-md-4">
                <label for="service_id">Dịch vụ (Chuyên môn)</label>
                <select name="service_id" id="service_id" class="form-control">
                    <option value="">-- Tất cả dịch vụ --</option>
                    <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($service->id); ?>" <?php echo e(($filters['service_id'] ?? '') == $service->id ? 'selected' : ''); ?>>
                            <?php echo e($service->name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="form-group col-md-4 d-flex align-items-end">
                <button type="submit" class="btn btn-primary mr-2"><i class="fas fa-filter"></i> Lọc</button>
                <a href="<?php echo e(route('admin.employee-skills.index')); ?>" class="btn btn-secondary"><i class="fas fa-redo"></i> Làm mới</a>
            </div>
        </form>
    </div>
</div>

<!-- Table -->
<div class="card shadow mb-4">
    <div class="card-header py-3">
        <h6 class="m-0 font-weight-bold text-primary">Danh sách chuyên môn</h6>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Nhân viên</th>
                        <th>Vị trí</th>
                        <th>Chuyên môn</th>
                        <th>Thao tác</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($employee->id); ?></td>
                            <td><?php echo e($employee->user->name ?? 'N/A'); ?></td>
                            <td><?php echo e($employee->position ?? 'N/A'); ?></td>
                            <td>
                                <?php if($employee->services->isEmpty()): ?>
                                    <span class="text-muted">Chưa thiết lập</span>
                                <?php else: ?>
                                    <?php $__currentLoopData = $employee->services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <span class="badge badge-info"><?php echo e($service->name); ?></span>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </td>
                            <td class="text-center">
                                <div class="d-flex gap-1 justify-content-center">
                                    <a href="<?php echo e(route('admin.employee-skills.edit', $employee->id)); ?>" class="btn btn-sm btn-primary" title="Chỉnh sửa chuyên môn">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="5" class="text-center">Không có dữ liệu</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <?php if($employees->hasPages()): ?>
            <div class="d-flex justify-content-center mt-3">
                <?php echo e($employees->links()); ?>

            </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .gap-1 {
        gap: 0.25rem;
    }
    .gap-1 > * {
        margin-right: 0.25rem;
        margin-bottom: 0.25rem;
    }
    .gap-1 form {
        display: inline-block;
        margin-right: 0.25rem;
        margin-bottom: 0.25rem;
    }
    .gap-1 button, .gap-1 a {
        white-space: nowrap;
    }
</style>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\laragon\www\polyhair\resources\views/admin/employee-skills/index.blade.php ENDPATH**/ ?>