<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id();
            $table->string('name', 191);
            $table->decimal('price', 10, 2);
            $table->decimal('sale', 10, 2)->default(0);
            $table->string('images', 191)->nullable();
            $table->foreignId('id_category')->constrained('categories')->onDelete('cascade');
            $table->tinyInteger('status')->default(1);
            $table->text('description')->nullable();
            $table->integer('views')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('products');
    }
};
