<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Review extends Model
{
    protected $fillable = [
        'appointment_id',
        'service_id',
        'employee_id',
        'user_id',
        'rating',
        'comment',
        'images',
        'is_hidden',
    ];

    protected $casts = [
        'rating' => 'integer',
        'images' => 'array',
        'is_hidden' => 'boolean',
    ];

    /**
     * Check if this is a comment (no appointment, no rating required)
     */
    public function isComment(): bool
    {
        return $this->appointment_id === null;
    }

    /**
     * Check if this is a review (has appointment and rating)
     */
    public function isReview(): bool
    {
        return $this->appointment_id !== null && $this->rating !== null;
    }

    /**
     * Get the appointment that owns the review.
     */
    public function appointment(): BelongsTo
    {
        return $this->belongsTo(Appointment::class);
    }

    /**
     * Get the service that owns the review.
     */
    public function service(): BelongsTo
    {
        return $this->belongsTo(Service::class);
    }

    /**
     * Get the employee that owns the review.
     */
    public function employee(): BelongsTo
    {
        return $this->belongsTo(Employee::class);
    }

    /**
     * Get the user that owns the review.
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }
}

